! @(#)lnident.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:38:26
! @(#)lnident.prg	6.5  (ESO)  7/26/93  17:28:56
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.COPYRIGHT   (C) 1993 European Southern Observatory
!.IDENT       lnident.prg
!.AUTHORS     Pascal Ballester (ESO/Garching) 
!             Cristian Levin   (ESO/La Silla)
!.KEYWORDS    Spectroscopy, Long-Slit
!.PURPOSE     
!                line identification in long slit reduction
!                command:
!                          IDENTIFY/LONG
!
!.VERSION     1.0  Package Creation  17-MAR-1993  
!-------------------------------------------------------
!
CROSSREF wlc ystart lintab  tol
!
DEFINE/PARAM  P1  {WLC}     CHAR  "Wavelength calibration frame : "
DEFINE/PARAM  P2  {YSTART}  NUMB  "Ystart : "
DEFINE/PARAM  P3  {LINTAB}  CHAR  "Line table : "
!DEFINE/PARAM  P4    4.      NUMB  "Error:"
!
DEFINE/MAXPAR 4
!
DEFINE/LOCAL CMD/C/1/20 'MID$CMND'
DEFINE/LOCAL TOLER/D/1/1 0.
IF P4(1:1) .EQ. "?"  THEN
   TOLER = 4. * STEP(1)
ELSE
   TOLER = {P4}
ENDIF
!
VERIFY/LONG  {P1} IMA
SET/LONG  WLC={P1}  YSTART={P2}   LINTAB={P3} 
!
GRAPH/SPEC
RESET/GRAPH
!
IF YSTART .EQ. 0     YSTART  = npix(2)/2
compute/table     {LINTAB}    :IDENT=NULL
@s lnident,seline
!                                           local variables
!
IF OUTPUTI(1) .EQ. 0  THEN
   WRITE/OUT "Error: Wrong parameter YSTART = 'YSTART'"
   RETURN/EXIT
ENDIF
!
IF CMD(1:1) .EQ. "X" THEN
   set/gcursor ? c_hair
   $ $GUI_EXE/ident.exe {aux_mode(3)} &
   RETURN
ENDIF
!
plot/row          {WLC}       @'YSTART' 
identify/gcursor  {LINTAB}    :IDENT :X   {TOLER}
select/table      {LINTAB}     ALL

RETURN


ENTRY SELINE

DEFINE/PARAM P1  {LINTAB}  TAB
DEFINE/PARAM P2  {YSTART}  NUMB
!
define/local  midscan/D/1/1  0.	
define/local  wcbin/D/1/1    0.

IF {P2} .LT. 0 .OR. {P2} .GT. NPIX(2) THEN
      WRITE/OUT "Error: Wrong parameter YSTART = 'P2'"
      RETURN/EXIT
ENDIF
!
wcbin                        = YSTEP*STEP(2)/2.
wcbin = M$ABS(wcbin)
!
IF {P2} .EQ. 0 .AND. NPIX(2) .EQ. 1 THEN
   midscan = 1.0
   wcbin = 0.2
ELSE IF {P2} .EQ. 1  .OR. {P2} .EQ. NPIX(2) THEN
   midscan  = start(2) + ({P2}-1.)*step(2)
ELSE
   midscan  = start(2) + ({P2}-0.9)*step(2)
ENDIF
!
select/table  {P1}   ABS(:Y-('midscan')).le.'wcbin'
!
IF OUTPUTI(1) .EQ. 0  THEN
      WRITE/OUT "Error: Wrong parameter YSTART = 'P2'"
      RETURN/EXIT
ENDIF
!
RETURN
