! @(#)necverif.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:35:50
! @(#)necverif.prg	16.1.1.1  (ESO)  06/19/01  15:35:50
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!.COPYRIGHT   (C) 1991 European Southern Observatory
!.IDENT       echcheck.prg
!.AUTHOR      Pascal Ballester,  ESO - Garching
!.KEYWORDS    Spectroscopy, Echelle, 
!.PURPOSE     Command CHECK/ECHELLE 
!.VERSION     1.0    Creation    30-JUL-1991  PB
!
!-------------------------------------------------------
!
define/param  P1   ?       I     "Input file:"
define/param  P2   FRAME   C     "File type" !FRAM,EXTR,REB,TAB,OTIME,AGAINST

IF P2(1:1) .EQ. "T" THEN    ! Check if P1 exist as a table
   IF M$INDEX(P1,".tbl") .LT. 1  P1 = "{P1}.tbl"
ELSE
   IF M$INDEX(P1,".bdf") .LT. 1  P1 = "{P1}.bdf"
ENDIF

IF M$EXIST(P1) .NE. 1 THEN
   WRITE/OUT "File {P1} not present or not available."
   RETURN/EXIT
ENDIF

IF P2(1:1) .EQ. "T"  RETURN  ! End of test for a table

!IF EXTMTD(1:1) .EQ. "O" .AND. FFOPT(1:1) .EQ. "Y" THEN
!   WRITE/OUT "***********************************************************"
!   WRITE/OUT "Warning: Incompatibles options FFOPT=YES and EXTMTD=OPTIMAL"
!   WRITE/OUT "         Optimal extraction requires to preserve the "
!   WRITE/OUT "         original number of counts of the spectrum"
!   WRITE/OUT "***********************************************************"
!ENDIF

DEFINE/LOCAL  SUM/I/1/1      0
DEFINE/LOCAL  ERRFLAG/I/1/1  0
DEFINE/LOCAL  ANSW/C/1/3     HAY

IF P2(1:1) .EQ. "A" THEN     ! Check image P1 against P3

   IF {{P1},NAXIS} .NE. {{P3},NAXIS}        ERRFLAG = 1

   IF ERRFLAG .EQ. 1 GOTO  HALT

   IF {{P1},START(1)} .NE. {{P3},START(1)}  ERRFLAG = 1
   IF {{P1},STEP(1)}  .NE. {{P3},STEP(1)}   ERRFLAG = 1

   IF {{P1},NAXIS} .EQ. 2 THEN
      IF {{P1},START(2)} .NE. {{P3},START(2)}  ERRFLAG = 1
      IF {{P1},STEP(2)}  .NE. {{P3},STEP(2)}   ERRFLAG = 1
   ENDIF

HALT:

   IF ERRFLAG .EQ. 1 THEN

      WRITE/OUT "***************************************************"
      WRITE/OUT "*** Error : Frames {P1} and {P3} do not match "
      WRITE/OUT "***         Now displaying standard descriptors "
      WRITE/OUT "***************************************************"
      READ/DESCR {P1}
      WRITE/OUT "***************************************************"
      READ/DESCR {P3}
     
   ENDIF

ENDIF


IF P2(1:1) .EQ. "F"  THEN          ! Check for a normal frame

   SUM = IMSIZE(1)+IMSIZE(2)
   IF SUM .EQ. 0 THEN              ! Initialize keyword IMSIZE
      IMSIZE(1)  =  {{P1},NPIX(1)}
      IMSIZE(2)  =  {{P1},NPIX(2)}
      WRITE/OUT  "************************************"
      WRITE/OUT  "Warning    : Update keyword IMSIZE  "
      WRITE/OUT  "Dimensions : {IMSIZE(1)},{IMSIZE(2)}"
      WRITE/OUT  "************************************"
   ENDIF

   SUM = SCAN(1)+SCAN(2)
   IF SUM .EQ. 0 THEN
      SCAN(1) = 1
      SCAN(2) = IMSIZE(2)
      WRITE/OUT  "******************************"
      WRITE/OUT  "Warning: Update keyword SCAN  "
      WRITE/OUT  "Limits : {SCAN(1)},{SCAN(2)}  "
      WRITE/OUT  "******************************"
   ENDIF

   UPDATE/ECHELLE {P1}

ENDIF

IF P2(1:1) .EQ. "O" THEN   ! Check for O_TIME descriptor

! An optional default observation time value can be passed through P3

DEFINE/LOCAL TIME/D/1/1  1.
DEFINE/LOCAL ITIME/I/1/1 0
!
! Check exposure time
!
ITIME = M$EXISTD(P1,"O_TIME")
IF ITIME .EQ. 1 THEN
  WRITE/KEYW TIME/D/1/1 {{P1},O_TIME(7)}
  IF TIME .GT. 0.00001 THEN
    WRITE/OUT "Exposure time : 'TIME' secs."
    ITIME = 0
  ENDIF
ELSE
  ITIME = 1
ENDIF
!
! After the previous check, if ITIME = 1, the time has to be entered
!
IF ITIME .EQ. 1 THEN
   IF M$EXISTD(P1,"O_TIME") .NE. 1 WRITE/DESCR {P1} O_TIME/D/1/8 0. all
   IF P3(1:1) .EQ. "?" THEN
      INQUIRE/KEYW TIME " Enter exposure time (in secs.):"
   ELSE
     TIME = {P3}
     WRITE/OUT "Enforced exposure time : 'TIME' secs."
   ENDIF
   WRITE/DESCR {P1} O_TIME/D/7/1 'TIME'
ENDIF

ERRFLAG = 0

ENDIF


IF ERRFLAG .NE. 0  THEN
   INQUIRE/KEYWORD ANSW/C/1/3   "Continue anyway (y/n,def=n) ? "
   IF AUX_MODE(7) .EQ. 0  RETURN/EXIT
   IF ANSW(1:1) .EQ. "Y"  RETURN
   RETURN/EXIT
ENDIF


RETURN


