! @(#)necextr.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:35:45
! @(#)necextr.prg	16.1.1.1  (ESO)  06/19/01  15:35:45
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.COPYRIGHT   (C) 1991 European Southern Observatory
!.IDENT       echextr.prg
!.AUTHOR      Pascal Ballester,  ESO - Garching
!.KEYWORDS    Spectroscopy, Echelle, 
!.PURPOSE     Command EXTRACT/ECHELLE INPUT OUTPUT W,OFF,A[,WS,OFF1,OFF2]
!.VERSION     1.0    Creation   31-JUL-1991  PB
!-------------------------------------------------------
!
DEFINE/PARAM P1 ?       IMAGE  "Enter input image:"
DEFINE/PARAM P2 ?       IMAGE  "Enter output extracted orders:"
DEFINE/PARAM P3 {SLIT}  N "Extraction params (slit,offset or slit,ron,g,sigma):" 
DEFINE/PARAM P4 {EXTMTD}  C      "Extraction method"
!
! Check extraction method
!
DEFINE/LOCAL ERRFLAG/I/1/1  1

IF P4(1:1) .EQ. "L"  ERRFLAG = 0
IF P4(1:1) .EQ. "A"  ERRFLAG = 0
IF P4(1:1) .EQ. "O"  ERRFLAG = 0
IF ERRFLAG .EQ. 0  THEN
   SET/ECHELLE EXTMTD={P4}
ELSE
   ERROR/ECHELLE EXTRACT/ECHELLE  EXTMTD
ENDIF
!
! Update extraction parameters
!
DEFINE/LOCAL W/R/1/4   0. ALL
!
IF EXTMTD(1:1) .EQ. "O" THEN
  WRITE/KEYW W/R/1/4  {SLIT},{RON},{GAIN},{EXTSIGMA}
  WRITE/KEYW W/R/1/4  {P3}
  SLIT     = W(1)
  RON      = W(2)
  GAIN     = W(3)
  EXTSIGMA = W(4)
ELSE
  WRITE/KEYW W/R/1/2  {SLIT},{OFFSET}
  WRITE/KEYW W/R/1/2  {P3}
  SLIT     = W(1)
  OFFSET   = W(2)
ENDIF
!
VERIFY/ECHELLE {P1}
IF SLIT      .LE. 0.     ERROR/ECHELLE EXTRACT/ECHELLE  SLIT
IF ECHORD(1) .LE. 0      ERROR/ECHELLE EXTRACT/ECHELLE  ECHORD(1)
IF RON       .LT. 0.     ERROR/ECHELLE EXTRACT/ECHELLE  RON
IF GAIN      .LT. 0.     ERROR/ECHELLE EXTRACT/ECHELLE  GAIN
IF EXTSIGMA  .LT. 0.     ERROR/ECHELLE EXTRACT/ECHELLE  EXTSIGMA
!
IF EXTMTD(1:1) .EQ. "O" THEN
 EXTRACT/OPTIMAL {P1} {P2} {SLIT},{echord(4)},{ECHORD(5)} {RON},{GAIN},{EXTSIGMA} {ORDTAB} COEFF
ELSE
 EXTR/ORDER {P1} {P2} {W(1)},0.,{W(2)} {P4} {ORDTAB} COEFF {echord(4)},{ECHORD(5)}
ENDIF
!
COPY/DD   {P1} *,3   {P2}
!
RETURN




