/* @(#)tbrules.c	16.1.1.1 (ES0-DMD) 06/19/01 15:34:52 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Module
.NAME        tbrules.c
.LANGUAGE    C
.AUTHOR      IPG-ESO Garching
.CATEGORY    Data Organizer utilities 
.COMMENTS       This module implements the following Midas commands:
\begin{TeX}
\begin{enumerate}
\item {\tt CREATE/RULE table rule
\end{enumerate}
\end{TeX}

.VERSION  1.0   15-Mar-1993  Definition     M. Peron
-----------------------------------------------------------------*/
#include <atype.h>
#include <tbldef.h>
#include <tblsys.h>
#include <tblerr.h>
#include <midas_def.h>
#include <macrogen.h>
#include <proto_tbl.h>
char *osmmget();
char *mystand[] = { 
                  "TBLENGTH","TBLOFFST","TBLCONTR","TSELTABL",
                   "TLABL"
                  }; 
main()
{
int status,tid,tid0,nrow,ncol,nicol;
int null, len, lennew, dummy;
int colc,colr;
int i,start,n,unit ;
char selrules[256], line[40],column[1+TBL_LABLEN];
char selecrit[256],outdescr[8],action[2];
char intable[60],label[13];
char temptable[60],*temp,text[60];
status = SCSPRO("tbrules");
strcpy(temptable,"TEMP_TAB");
SCKGETC("ACTION",1L,1L,&dummy,action);
SCKGETC("INPUTC",1L,8L,&dummy,outdescr);
for (i=0;i<5;i++) 
if ((n = stuindex(outdescr,mystand[i])) == 0 ){
   sprintf(text,"Error writing in standard descriptor: %s",outdescr);
   SCETER(1,text);
   }
SCKGETC("IN_A",1L,60L,&dummy,intable);
TCTOPN(intable,F_IO_MODE,&tid0);
if (action[0] == 'C') {
    status = TCIGET(tid0,&nicol,&dummy,&dummy,&dummy,&dummy);
    TCTINI("TEMP_TAB",F_TRANS,F_IO_MODE,2,nicol,&tid);
    TCCINI(tid,D_C_FORMAT,13L,"A13"," ","COLUMN",&colc);
    for (i=0; i<nicol; i++) {
        TCLGET(tid0,i+1,label);
        TCEWRC(tid,i+1,1L,label);
    }
    TCCINI(tid,D_C_FORMAT,40L,"A40"," ","RULE",&colr);
    }
else {
    status = TCTOPN(temptable,F_I_MODE,&tid);
    status = TCIGET(tid,&dummy,&nrow,&dummy,&dummy,&dummy);
    SCKGETC("INPUTC",1L,8L,&dummy,outdescr);
/*    SCKGETC(outkey,1L,256L,&len,selecrit); */
    temp = osmmget(256);
    oscfill(selecrit,256,'\0');
    for (i=0; i<nrow; i++) {
       status = TCERDC(tid,i+1,2L,line,&null);
       if (null) continue;
       *column = ':';
       status = TCERDC(tid,i+1,1L,column+1,&null);
       if (selecrit[0] != '\0') strcat(selecrit,".AND.");
       decrypt1(column,line,selecrit,temp);
       lennew = strlen(selecrit);
       len += lennew;
       }
    status = SCDWRC(tid0,outdescr,1L,selecrit,1L,lennew,&unit);
     }
tbl_hist(tid0);
SCSEPI();
}



      
