/* @(#)nrutil.c	16.1.1.1 (ESO-IPG) 06/19/01 15:33:43 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/
#include <stdlib.h>
#include <stdio.h>

float *vector(nl,nh)
int nl,nh;
{
	float *v;

	v=(float *) malloc((unsigned) (nh-nl+1)*sizeof(float));
	if (!v) SCETER("FATAL: Memory allocation failure in routine vector");
	return v-nl;
}

void free_vector(v,nl,nh)
float *v;
int nl,nh;
{
	free((char*) (v+nl));
}


float **matrix(nrl,nrh,ncl,nch)
int nrl,nrh,ncl,nch;
{
	int i;
	float **m;

	m=(float **) malloc((unsigned) (nrh-nrl+1)*sizeof(float*));
	if (!m)  
           SCETER("FATAL: Memory allocation failure 1 in routine matrix");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
	   m[i]=(float *) malloc((unsigned) (nch-ncl+1)*sizeof(float));
	   if (!m[i]) 
              SCETER("FATAL: Memory allocation failure 2 in routine matrix");
	   m[i] -= ncl;
	}
	return m;
}


void free_matrix(m,nrl,nrh,ncl,nch)
float **m;
int nrl,nrh,ncl,nch;
{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}




