/* @(#)mptest.c	16.1.1.1 (ES0-DMD) 06/19/01 15:30:10 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++   
.TYPE           Program
.LANGUAGE       C
.IDENTIFICATION mptest.c
.VERSION        1.0
.AUTHOR         Francois Ochsenbein [ESO-IPG]
.KEYWORDS       Test of main functions
.ENVIRONMENT    
.COMMENTS       Following the present rules allows an automatic insertion in
                the Software Data-base
 
.VERSION 1.0 	05-Nov-1986: Creation
.VERSION 1.1 	21-Oct-1988: Cosmetic modifications

--------------------------------*/

#include <atype.h>
#include <pgm.h>

static char msg[140];

static int list(p)
/*+++
.PURPOSE List retrieved parameter
.RETURNS OK
---*/
	char *p;
{
  if (p)
	printf("==>%s\n",p);
  else	puts("******* Not possible ***");

  return(0);
}

PGM(test)
/*+++++++++++++++++++++++ 
.PURPOSE Test the input parameters
.RETURNS to OS
.REMARKS Existence of parameters requires a definition as a foreign, i.e.
         TEMPLATE := $ device:[directory]file
------------------------------------------------------------------------*/

{ int n;
  char *p;

  SaveParms();

  while (1)
  {	printf("Your choice: ");
	if(!gets(msg))	break;
	switch(toupper(msg[0]))
	{ default : 
		puts("F : Flagged parameter");
		puts("G : Get numbered parameter");
		puts("N : get next parameter");
		puts("O : get option parameter");
		puts("S : get option string");
		break;
	  case 'F':	/* Get flagged parameter	*/
		printf("Flag char=>");	gets(msg);
		list(GetFlaggedParm(msg[0]));
		break;
	  case 'G':	/* Get a parameter	*/
		printf("Arg. #");	gets(msg);
		n = atoi(msg);
		list(GetParm(n));
		break;
	  case 'N':	/* Get Next		*/
		list(GetNextParm());
		break;
	  case 'O':	/* Option parameter	*/
		printf("Option letter=>");	gets(msg);
		printf("Value of option is: %d\n",GetOption(tolower(msg[0])));
		break;
	  case 'S':	/* Option parameter	*/
		printf("Option letter=>");	gets(msg);
		list(GetsOption(tolower(msg[0])));
		break;
	}
  }		

}
