/* @(#)ebcdic.c	16.1.1.1 (ES0-DMD) 06/19/01 15:30:09 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++ EBCDIC +++++++++++++++++++++
.MODULE 	ebcdic.c
.VERSION 1.0	19-Dec-1985: Creation
.VERSION 1.1	11-Mar-1987: Cosmetic modifications
.VERSION 1.2	13-Jun-1988: Use OS definitions
.AUTHOR		Francois Ochsenbein [ESO]
.LANGUAGE  	C
.CATEGORY  	string translation

.COMMENTS	This module includes the tables for translation 
		between ASCII and EBCDIC character sets.

---------------------*/
 

#include <osdefos.h>

#define ____	0xff		/* No Translation	*/

		/* ASCII to EBCDIC translation table */

MID_GLOBAL unsigned char asc_to_ebc[256] = { 
   0X00, 0X01, 0X02, 0X03, 0X37, 0X2D, 0X2E, 0X2F,   /* 0x00 to 0x07 */
   0X16, 0X05, 0X25, 0X0B, 0X0C, 0X0D, 0X0E, 0X0F,   /* 0x08 to 0x0f */
   0X10, 0X11, 0X12, 0X13, 0X3C, 0X3D, 0X32, 0X26,   /* 0x10 to 0x17 */
   0X18, 0X19, 0X3F, 0X27, 0X1C, 0X1D, 0X1E, 0X1F,   /* 0x18 to 0x1f */
   0X40, 0X4F, 0X7F, 0X7B, 0X5B, 0X6C, 0X50, 0X7D,       /*  !"#$%&' */
   0X4D, 0X5D, 0X5C, 0X4E, 0X6B, 0X60, 0X4B, 0X61,       /* ()*+,-./ */
   0XF0, 0XF1, 0XF2, 0XF3, 0XF4, 0XF5, 0XF6, 0XF7,       /* 01234567 */
   0XF8, 0XF9, 0X7A, 0X5E, 0X4C, 0X7E, 0X6E, 0X6F,       /* 89:;<=>? */
   0X7C, 0XC1, 0XC2, 0XC3, 0XC4, 0XC5, 0XC6, 0XC7,       /* @ABCDEFG */
   0XC8, 0XC9, 0XD1, 0XD2, 0XD3, 0XD4, 0XD5, 0XD6,       /* HIJKLMNO */
   0XD7, 0XD8, 0XD9, 0XE2, 0XE3, 0XE4, 0XE5, 0XE6,       /* PQRSTUVW */
   0XE7, 0XE8, 0XE9, 0X4A, 0XE0, 0X5A, 0X5F, 0X6D,       /* XYZ[\]^_ */
   0X79, 0X81, 0X82, 0X83, 0X84, 0X85, 0X86, 0X87,       /* `abcdefg */
   0X88, 0X89, 0X91, 0X92, 0X93, 0X94, 0X95, 0X96,       /* hijklmno */
   0X97, 0X98, 0X99, 0XA2, 0XA3, 0XA4, 0XA5, 0XA6,       /* pqrstuvw */
   0XA7, 0XA8, 0XA9, 0XC0, 0X6A, 0XD0, 0XA1, 0X07,       /* xyz{|}~  */
   /* . . More . . . if first bit set to 1 ...  */
   0X00, 0X01, 0X02, 0X03, 0X37, 0X2D, 0X2E, 0X2F,   /* 0x80 to 0x87 */
   0X16, 0X05, 0X25, 0X0B, 0X0C, 0X0D, 0X0E, 0X0F,   /* 0x88 to 0x8f */
   0X10, 0X11, 0X12, 0X13, 0X3C, 0X3D, 0X32, 0X26,   /* 0x90 to 0x97 */
   0X18, 0X19, 0X3F, 0X27, 0X1C, 0X1D, 0X1E, 0X1F,   /* 0x98 to 0x9f */
   0X40, 0X4F, 0X7F, 0X7B, 0X5B, 0X6C, 0X50, 0X7D,       /*  !"#$%&' */
   0X4D, 0X5D, 0X5C, 0X4E, 0X6B, 0X60, 0X4B, 0X61,       /* ()*+,-./ */
   0XF0, 0XF1, 0XF2, 0XF3, 0XF4, 0XF5, 0XF6, 0XF7,       /* 01234567 */
   0XF8, 0XF9, 0X7A, 0X5E, 0X4C, 0X7E, 0X6E, 0X6F,       /* 89:;<=>? */
   0X7C, 0XC1, 0XC2, 0XC3, 0XC4, 0XC5, 0XC6, 0XC7,       /* @ABCDEFG */
   0XC8, 0XC9, 0XD1, 0XD2, 0XD3, 0XD4, 0XD5, 0XD6,       /* HIJKLMNO */
   0XD7, 0XD8, 0XD9, 0XE2, 0XE3, 0XE4, 0XE5, 0XE6,       /* PQRSTUVW */
   0XE7, 0XE8, 0XE9, 0X4A, 0XE0, 0X5A, 0X5F, 0X6D,       /* XYZ[\]^_ */
   0X79, 0X81, 0X82, 0X83, 0X84, 0X85, 0X86, 0X87,       /* `abcdefg */
   0X88, 0X89, 0X91, 0X92, 0X93, 0X94, 0X95, 0X96,       /* hijklmno */
   0X97, 0X98, 0X99, 0XA2, 0XA3, 0XA4, 0XA5, 0XA6,       /* pqrstuvw */
   0XA7, 0XA8, 0XA9, 0XC0, 0X6A, 0XD0, 0XA1, 0X07        /* xyz{|}~  */
   };

	/* EBCDIC to ASCII translation table */

MID_GLOBAL unsigned char ebc_to_asc[256] = {
    00,  01,  02,  03,____,0011,____,0177, /* 0. */
  ____,____,____,0013,0014,0015,0016,0017, /* 0. */
   020,0021,0022,0023,____,____,0010,____, /* 1. */
   030,0031,____,____,0034,0035,0036,0037, /* 1. */
  ____,____,____,____,____,0012,0027,0033, /* 2. */
  ____,____,____,____,____,0005,0006,0007, /* 2. */
  ____,____,0026,____,____,____,____,0004, /* 3. */
  ____,____,____,____,0024,0025,____,0032, /* 3. */
   ' ',____,____,____,____,____,____,____, /* 4. */
  ____,____, '[', '.', '<', '(', '+', '!', /* 4. */
   '&',____,____,____,____,____,____,____, /* 5. */
  ____,____, ']', '$', '*', ')', ';', '^', /* 5. */
   '-', '/',____,____,____,____,____,____, /* 6. */
  ____,____, '|', ',', '%', '_', '>', '?', /* 6. */ 
  ____,____,____,____,____,____,____,____, /* 7. */
  ____, '`', ':', '#', '@','\'', '=','\"', /* 7. */
  ____, 'a', 'b', 'c', 'd', 'e', 'f', 'g', /* 8. */
   'h', 'i',____,____,____,____,____,____, /* 8. */
  ____, 'j', 'k', 'l', 'm', 'n', 'o', 'p', /* 9. */
   'q', 'r',____,____,____,____,____,____, /* 9. */
  ____, '~', 's', 't', 'u', 'v', 'w', 'x', /* a. */ 
   'y', 'z',____,____,____,____,____,____, /* a. */
  ____,____,____,____,____,____,____,____, /* b. */
  ____,____,____,____,____,____,____,____, /* b. */
   '{', 'A', 'B', 'C', 'D', 'E', 'F', 'G', /* c. */
   'H', 'I',____,____,____,____,____,____, /* c. */
   '}', 'J', 'K', 'L', 'M', 'N', 'O', 'P', /* d. */
   'Q', 'R',____,____,____,____,____,____, /* d. */
  '\\',____, 'S', 'T', 'U', 'V', 'W', 'X', /* e. */
   'Y', 'Z',____,____,____,____,____,____, /* e. */
   '0', '1', '2', '3', '4', '5', '6', '7', /* f. */
   '8', '9',____,____,____,____,____,____  /* f. */
    };

