/* @(#)tdatanew.c	16.1.1.1 (ES0-DMD) 06/19/01 15:29:58 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Module
.NAME        tdatatbl.c
.LANGUAGE    C
.AUTHOR      J.D.Ponz  IPG-ESO Garching
.CATEGORY    table aplication (Design 2.0)
.COMMENTS    This module contains the code executed with the commands
             
             create/table, show/table, read/table, print/table,
             delete/column, create/column, merge/table, name/column,
             sort/table, project/table, union/table
    
.PURPOSE     Main program activating the different routines.

.VERSION     1.0 25-Mar-1989 JDP  Implementation      
.VERSION     1.1 16-Jan-1990 JDP  Include WRITE/TABLE 
.VERSION     1.2 16-Jan-1990 JDP  Include COPY/KT, COPY/TK     
.VERSION     1.3 07-Dec-1990 FO   Added tbl_retro (Conversion)
------------------------------------------------------------*/

main()
{
 long status, npar, iav, knull;                         

 char command[8], *kunit;

 int  tbl_create(),  tbl_read(),   tbl_show(),  tbl_sort(), tbl_delcol();
 int  tbl_creacol(), tbl_copy(),   tbl_merge(), tbl_namecol();
 int  tbl_project(), tbl_setref(), tbl_write();
 int  tbl_copykt(),  tbl_copytk(), tbl_crview();
 int  tbl_retro();

                                          /* get into MIDAS */
  status = SCSPRO("TDATATBL");
  
                                          /* get command name */
  status = tbl_getpar("TACT",5,command);

                                          /* define actions in the program */

  tk_add(0,0,tbl_copy,    "copta");           
  tk_add(1,0,tbl_creacol, "creco");           
  tk_add(2,0,tbl_create,  "creta");          
  tk_add(3,0,tbl_crview,  "crevi");          
  tk_add(4,0,tbl_merge,   "merta");           
  tk_add(5,0,tbl_namecol, "namco");           
  tk_add(6,0,tbl_project, "prota");           
  tk_add(7,0,tbl_read,    "reata");           
  tk_add(8,0,tbl_setref,  "setre");           
  tk_add(9,0,tbl_show,    "shota");           
  tk_add(10,0,tbl_sort,   "sorta");           
  tk_add(11,0,tbl_read,   "prita");           
  tk_add(12,0,tbl_write,  "writa");           
  tk_add(13,0,tbl_delcol, "delco");           
  tk_add(14,0,tbl_copytk, "coptk");           
  tk_add(15,0,tbl_copykt, "copkt");           
  tk_add(16,0,tbl_retro,  "retta");           /* Retro/Table */
  
                                          /* execute command */

  status = tk_cexec(command);  

  if (status < 0) SCTPUT("Warning on status return");
  
  SCSEPI();    
  ospexit(0);
}
