/* @(#)tbproject.c	16.1.1.1 (ES0-DMD) 06/19/01 15:29:43 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* @(#)tbproject.c	6.1 (ESO-IPG) 7/16/93 16:42:36 */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Module
.NAME        tbproject.c
.LANGUAGE    C
.AUTHOR      IPG-ESO Garching
.CATEGORY    table utilities

.COMMENTS       This module implements the following Midas commands:
\begin{TeX}
\begin{enumerate}
\item {\tt PROJECT/TABLE} intable outable {\em column\_selection} 
\end{enumerate}
\end{TeX}

.VERSION 1.0 	25-Mar-1989   Definition     J.D. Ponz
.VERSION 3.0 	05-Jul-1990   New version with column arrays   F.O.
.VERSION 3.1    21-JAn-1991    MP
------------------------------------------------------------*/

#include <tbldef.h>
#include <midas_def.h>
#include <proto_tbl.h>


#define PARLEN 80
#define COLS   64

tbl_project()
/*++++++++++++++++++
.PURPOSE PROJECT/TABLE source_table dest_table :col_selection 
.RETURNS Status
------------------*/
{
  char param[PARLEN], outable[PARLEN], label[1+TBL_LABLEN];
  char form[10], unit[1+TBL_UNILEN];
  int  status, argc, i;
  int tid, tout, ncol, nrow, nout, dummy, icol[COLS], flag[COLS];
  int phform, nr, nbtot, bytes, items, ic, nc, type, oc;

						/* read parameters */

  argc = tbl_argc();
  nc = 0;
  tbl_getarg(1, PARLEN, param);

  status = TCTOPN(param, F_I_MODE, &tid);
  if (status != ERR_NORMAL) {
  	SCTPUT("Error opening input table");
	return (status);
  }

						/* Get columns	*/
  outable[0] = '\0';
  for (i = 2; i <= argc; i++) {
     	tbl_getarg(i, PARLEN, param);
        if (i==8 && param[strloc(param,' ')]) {
               param[strloc(param,' ')] = '\0';
               SCTPUT ("***Warning*** Command Line truncated to 8 parameters");
               SCTPUT("Check Help  PROJECT/TABLE for more info");
               }
     	if ( (outable[0] == '\0') && (param[0] != ':') && (param[0] != '#'))
     		strcpy (outable, param);
	else {
		TCCSEL(tid, param, COLS-nc, &icol[nc], &flag[nc], &ic);
		if (ic < 0) {
			status = ERR_TBLCOL; 
			SCTPUT("****Column(s) not found");
			goto error;
		}
        nc += ic;
	}
/*	nc  += ic;   MP 1991 */
  }

  if (outable[0] == '\0') {
       status = ERR_FILBAD;
       SCTPUT("***Wrong Output Table Name");
       goto error;
       }
  TCIGET(tid, &ncol, &nrow, &dummy, &dummy, &dummy);
  TCDGET(tid, &phform);
  TCSCNT(tid, &nr);

						/* count required space */
  nbtot = 0; 
  for (i = 0; i < nc; i++) {
	TCBGET (tid, icol[i], &type, &items, &bytes);
	nbtot += bytes;
  }

  nbtot = (nbtot+3)/4;				/* Size for TCTINI 	*/
  if (nbtot & 1)	nbtot++;	
  nr = 8*((nr+7)/8);

  status = TCTINI(outable, phform, (nc<<16)|(F_O_MODE|F_ALL_FORCE),
  	nbtot, nr, &tout);
  if (status != ERR_NORMAL) {
  	SCTPUT("Error creating output table");
	return (status);
  }

					/* create the columns and copy them*/
  for (i = 0; (status == ERR_NORMAL) && (i< nc); i++) {
	ic = icol[i];
	TCFGET (tid, ic, form,  &dummy, &type);
	TCLGET (tid, ic, label);
	TCUGET (tid, ic, unit);
	TCBGET (tid, ic, &type, &items, &bytes);
        if (type == D_C_FORMAT)
             status = TCCINI(tout, type, bytes, form, unit, label, &oc);
	else status = TCCINI(tout, type, items, form, unit, label, &oc);
        if (type == D_C_FORMAT && items !=1 )
            TCAPUT(tout,oc,items);
	status = tbl_copycol(tid,ic,tout,oc,type,nrow,&nout);
  }     

/* if (nr != nout) SCTPUT(" Warning: Not all the entries are projected "); */

 if (status == ERR_NORMAL) CGN_DSCUPD(tout,tout," ");
error:
 TCTCLO(tid);
 TCTCLO(tout);

 return (status);
}       
