/* @(#)tbcopy.c	16.1.1.1 (ES0-DMD) 06/19/01 15:29:42 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* @(#)tbcopy.c	6.1 (ESO-IPG) 7/16/93 16:43:12 */
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Module
.NAME        tbcopy.c
.LANGUAGE    C
.AUTHOR      IPG-ESO Garching
.CATEGORY    table utilities
.COMMENTS    Implementation of the Midas commands:
\begin{TeX}	
	\begin{enumerate}
	\item {\tt COPY/TT} source\_table :source\_col [dest\_table] :dest\_col

	Copy column from input table into the output table.
	If the reference column is defined, the copy is done according to
	values in this column. 
	By default the sequence number is used as a reference.
	\end{enumerate}
\end{TeX}

.VERSION 1.0 	25-Mar-1989   Definition     J.D. Ponz
.VERSION 3.0 	05-Jul-1990   New version with column arrays   F.O.
.VERSION 3.1 	27-Nov-1990: COPY/TT uses ALWAYS same row if same table
------------------------------------------------------------*/

#include <tbldef.h>
#include <tblerr.h>
#include <midas_def.h>
#include <proto_tbl.h>

#define PARLEN 80

tbl_copy()
/*++++++++++++++++++
.PURPOSE COPY/TT Midas Command
.RETURNS Status
------------------*/
{
  char *intable, *outable, *incol, *outcol;
  char parm[4][PARLEN];
  char form[10], unit[1+TBL_UNILEN];
  int  tidi, npar, iref, oref, bytes;
  int  nrow, status,i, ii, nout, io, type, alen, tido, dummy;

						/* get parameters */
  npar = tbl_argc();
  intable = outable = incol = outcol = (char *)0;

  if (npar > 4) 	SCTPUT("++++ Ignored argument(s):");
  while (npar > 4) {
	tbl_getarg (npar, PARLEN, parm[0]);
	SCTPUT (parm[0]);
	npar--;
  }

  for (i = 0; i < npar; i++) {
	tbl_getarg (i+1, PARLEN, parm[i]);
        if (parm[i][0] == '?') continue;
	if ((parm[i][0] == ':') || (parm[i][0] == '#')) {
		if (!incol)	incol  = parm[i];
		else		outcol = parm[i];
	}
	else	{
		if (!intable)	intable = parm[i];
		else		outable = parm[i];
	}
  }
  if (!outable)	outable = intable;
  if (!outcol)	outcol  = incol;
  
						/* open i/o table(s) */
  if (strcomp(intable, outable) == 0) {
	status = TCTOPN(intable, F_IO_MODE, &tidi);
	if (status != ERR_NORMAL) {
		SCTPUT("Error opening  table");
		return (status);
	}
	tido   = tidi;
  }
  else {
	status = TCTOPN(intable,F_I_MODE,&tidi);
 	if (status != ERR_NORMAL) {
 		SCTPUT("Error opening input table");
		return (status);
	}
      	status = TCTOPN(outable,F_IO_MODE,&tido);
      	if (status != ERR_NORMAL) {
      		SCTPUT("Error opening output table");
		return (status);
	}
  }
  						/* search for input column */
  TCCSER(tidi,incol,&ii);
  if (ii <= 0) {
  	SCTPUT("Input column not found "); 
  	status = ERR_TBLCOL; 
  	goto error;
  }
  TCIGET(tidi, &dummy, &nrow, &dummy, &dummy, &dummy);
  TCUGET(tidi,ii, unit);
  TCFGET(tidi,ii, form,&alen,&type);
  TCBGET(tidi,ii, &type, &alen, &bytes);

  						/* search for output column */
  TCCSER(tido,outcol,&io);
  if (io <= 0) {
        if (type == D_C_FORMAT)
            status = TCCINI(tido, type, bytes, form, unit, outcol, &io);
  	else status = TCCINI(tido, type, alen, form, unit, outcol, &io);
        if (type == D_C_FORMAT && alen !=1 )
            TCAPUT(tido,io,alen);


  	if (status)	goto error;
  }

  TCKGET(tidi, &iref);
  TCKGET(tido, &oref);
					/* copy by sequence or by reference */

  if (iref == 0 && oref == 0) 
	status = tbl_copycol(tidi,ii,tido,io,type,nrow,&nout);
  else 	status = tbl_copyref(tidi,ii,iref,tido,io,oref,type,nrow,&nout);

error:
 if (tido != tidi)
       {
        CGN_DSCUPD(tido,tido," ");
        TCTCLO(tido);
        TCTCLO(tidi);
       }
 else
       {
        CGN_DSCUPD(tidi,tidi," ");
       TCTCLO(tidi);
       }

 return (status);
}       
