/* @(#)tbcopima.c	16.1.1.1 (ESO-DMD) 06/19/01 15:29:42 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.TYPE        Module
.NAME        tbcopima.c
.LANGUAGE    C
.AUTHOR      IPG-ESO Garching
.CATEGORY    table utilities
.COMMENTS    This module implements the following Midas commands:
\begin{TeX}
\begin{enumerate}
\item {\tt COPY/TI} table image 
\item {\tt COPY/IT} image table
\end{enumerate}
\end{TeX}
.VERSION 1.0    18-dec-1992   Definition     M. Peron

 010530		last modif	KB

---------------------------------------------------------------*/
#include <atype.h>
#include <tbldef.h>
#include <tblsys.h>
#include <tblerr.h>
#include <midas_def.h>
#include <computer.h>
#include <macrogen.h>
#include <proto_tbl.h>

tbl_copyit()
/*++++++++++++++++++
.PURPOSE COPY/IT image table
.RETURNS Status
------------------*/
{
char inima[62],outtab[62],column[TBL_LABLEN];
char ident[72],cunit[33];
int kunit;
int dummy, icol, status, i, j, k;
int imno, naxis, npix[3], items;
int nrow, ncol, tid, ic, nar;
int actvals, null, id, type, nbytes;
double  start[3], step[3], val;
float *pntr;
char *dmapped;
status = SCKGETC("IN_A",1,60,&dummy,inima);
status = SCKGETC("OUT_A",1,60,&dummy,outtab);
status = SCKGETC("INPUTC",1,TBL_LABLEN,&dummy,column);
/*status = SCKRDR("NULL",1,1,&actvals,&rnull,&kunit,&null); */
if (column[0] == '+') {
         icol = 0; 
         strcpy(column,"LAB001");
         }
else icol=1;

ident[0] = cunit[0] = '\0';

status = SCIGET(inima,D_R4_FORMAT,F_I_MODE,F_IMA_TYPE,3,&naxis,
       npix,start,step,ident,cunit,(char **)&pntr,&imno);
if (naxis == 1) npix[1] = 1;
ncol = npix[1] + icol;
nrow = npix[0];
items = npix[2];
status = TCTINI(outtab,F_TRANS,F_O_MODE,ncol,nrow,&tid);
status = TCCINI(tid,D_R4_FORMAT,items,"E12.6"," ",column,&ic);
for (i = 2; i<= ncol; i++) {
    sprintf(column,"LAB00%d",i);
    status = TCCINI(tid,D_R4_FORMAT,items,"E12.6"," ",column,&ic);
    }
if (icol == 1)  for (i=1; i<= nrow; i++) {
                val = (i-1) * step[0] + start[0];
                status = TCEWRD(tid,i,1,&val);
                }
for (k= 0; k<items; k++) 
  for (j=icol; j<ncol; j++) 
       for (i=0; i<nrow; i++)  {
           TCAWRR(tid,i+1,j+1,k+1,1,pntr);
           pntr++;
           }
status = TCTCLO(tid);
return(status);
}

tbl_copyti()
/*++++++++++++++++++
.PURPOSE COPY/TI table image
.RETURNS Status
------------------*/
{
   char ident[72], cunit[68];
   char intab[62], outima[62];
   int kunit;
   int tid,ncol,nrow,nacol,narow,nrall;
   int imno, naxis, npix[3], actvals;
   int dummy,nbytes,type,id,items;
   int iColumnNum;
   int iRowNum;
   int iItemNum;
   int null, status, istat,index;
   double start[3], step[3];
   float *pntr, rnull,*rvalue;
   char *osmmget();
   int count;		/* number of selected rows               -> MIDEnv */
   int value;		/* row selection flag, can be TRUE/FALSE -> MIDEnv */
   int iSelectedRow;

   status = SCKGETC("IN_A",1,60,&dummy,intab);
   (void) strcpy(ident,"from ");
   (void) strcat(ident,intab);
   status = SCKGETC("OUT_A",1,60,&dummy,outima);
   status = SCKRDR("NULL",1,1,&actvals,&rnull,&kunit,&null); 
   status = TCTOPN(intab,F_I_MODE,&tid);
   status = TCIGET(tid,&ncol,&nrow,&nacol,&narow,&nrall);

   start[0] = start[1] = start[2] =  0;
   step[0] = step[1] = step[2] = 1;
   status = TCBGET(tid,1,&type,&items,&nbytes);
   if (items != 1)
   { 
       naxis = 3;
   }
   else 
   {
      if (ncol == 1) 
          naxis = 1; /* 1-D case*/
      else 
          naxis=2;   /* 2-D */
   }
   
/* Old: npix[0] = nrow;    total number of rows */
/* New: take only the selected rows PN 10/98*/

   status = TCSCNT(tid,&count);
   npix[0] = count;   /* number of columns currently selected */   
   npix[1] = ncol;    /* number of columns */
   npix[2] = items;
   rvalue = (float *) osmmget(items*sizeof(float));
   
/* 1. allocate space for the image: */   
   (void) strcpy(cunit,"       ");
   status = SCIPUT(outima,D_R4_FORMAT,F_O_MODE,F_IMA_TYPE,naxis,npix,
               start,step,ident,cunit,(char **)&pntr,&imno); 

/* 2. fill the image with values: */
					/* step through all columns */
   for (iColumnNum=0; iColumnNum<ncol; iColumnNum++)
       {
       status = TCBGET(tid,iColumnNum+1,&type,&items,&nbytes);
       iSelectedRow = 0;
	  				/* step through all rows  */
       for (iRowNum=0; iRowNum<nrow; iRowNum++) 
           {					/* take into account  */
	  					/* only selected rows */
	   status = TCSGET(tid,iRowNum+1,&value);
           if (value != 0)			/* test if row selected */
	       {	  	          				
               status = TCARDR(tid,iRowNum+1,iColumnNum+1,1,items,rvalue);
               for (iItemNum=0; iItemNum<items; iItemNum++) 	/* loop for array  */
	           {
		   index = 
                   iItemNum * count * ncol + count * iColumnNum + iSelectedRow;
                       
                   null = isNULLF(rvalue+iItemNum);
                   if (null == 1)
		      *(pntr+index) = rnull;    /* null elements will be set 
						   to null value defined by 
						   keyword NULL */
                   else 
		       *(pntr+index) = *(rvalue+iItemNum); /* values */
                   }
	       iSelectedRow++;
	       }
           }
       }

   osmmfree(rvalue);
   return(status);
}


