! @(#)vericopy.prg	16.1.1.1 (ESO-DMD) 06/19/01 15:28:56
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!  MIDAS procedure vericopy.prg  to copy the "verify" procedures
!        into the current directory
!  K. Banse     921202, 930628, 950914, 970324, 990329, 010302
!
! ++++++++++++++++++++++++++++++++++++++++++++++++++++++
! 
define/param p1 + C 
!
! handle in VMS or UNIX
! 
write/out Copying all the necessary procedures/files to current directory 
! 
if aux_mode(1) .le. 1 then		! VMS
   $DELETE/NOLOG/NOCONF all_*.prg.*,creamask.prg.*,works.prg.*
   $DELETE/NOLOG/NOCONF tst*.mt.*,PWDL_*.*.*,FORS*.fits.*,in3d.mt.*
   $DELETE/NOLOG/NOCONF verif*.prg.*,kcompare.prg.*,imcompare.prg.*
   $DELETE/NOLOG/NOCONF veritx.dat.*,veritb.dat.*,veriall.prg.*,*FITS.prg
   $DELETE/NOLOG/NOCONF foil.asc.*
   ! 
   define/local testdir/c/1/60 "MID_DISK:[&MIDASHOME.&MIDVERS.TEST.PRIM] "
   define/local defdir/c/1/2 "[]"
   $ COPY {testdir}all_*.prg {defdir}
   $ COPY {testdir}verif*.prg {defdir}
   $ COPY {testdir}*compare.prg {defdir}
   $ COPY {testdir}*FITS.prg {defdir}
   $ COPY {testdir}works.prg {defdir}
   $ COPY {testdir}creamask.prg {defdir}
   $ COPY {testdir}*.dat {defdir}
   $ COPY {testdir}*.fmt {defdir}
   $ COPY {testdir}veriall.prg {defdir}
   $ COPY {testdir}*.mt {defdir}
   $ COPY {testdir}*.fits {defdir}
   $ COPY {testdir}*.tfits {defdir}
   $ COPY {testdir}*.asc {defdir}
   !
   define/local fitsdir/c/1/60 "MID_DISK:[&MIDASHOME.&MIDVERS.TEST.FITS] "
   $ COPY {fitsdir}verif*.prg {defdir}
   $ COPY {fitsdir}tst*.mt {defdir}

else					! UNIX
   $rm -f all_*.prg creamask.prg works.prg
   $rm -f verif*.prg tst*.mt PWDL_*.*, FORS*.fits in3d.mt
   $rm -f kcompare.prg imcompare.prg *FITS.prg
   $rm -f veritb.dat veritx.dat veriall.prg
   $rm -f foil.asc bias-5ms-11cm.asc
   $rm -f *2000p.tfits
   ! 
   define/local testdir/c/1/60 "$MID_HOME/test/prim/ "
   define/local defdir/c/1/2 "./"
   $ cp {testdir}all_*.prg {defdir}
   $ cp {testdir}verif*.prg {defdir}
   $ cp {testdir}*compare.prg {defdir}
   $ cp {testdir}*FITS.prg {defdir}
   $ cp {testdir}works.prg {defdir}
   $ cp {testdir}creamask.prg {defdir}
   $ cp {testdir}*.dat {defdir}
   $ cp {testdir}*.fmt {defdir}
   $ cp {testdir}veriall.prg {defdir}
   $ cp {testdir}*.mt {defdir}
   $ cp {testdir}*.fits {defdir}
   $ cp {testdir}*.tfits {defdir}
   $ cp {testdir}*.asc {defdir}
   !
   define/local fitsdir/c/1/60 "$MID_HOME/test/fits/ "
   $ cp {fitsdir}verif*.prg {defdir}
   $ cp {fitsdir}tst*.mt {defdir}
   !
   if p1(1:3) .eq. "XXX" then
      $ rm -f Xveri*.prg
      $ cp {testdir}Xveri*.prg {defdir}
   endif
endif
! 
write/out To execute all verification procedures,
write/out "  enter the Midas command: @@ veriall parm1 parm2 parm3 "
write/out "  with parm1 = display (default) "
write/out "          or = nodisplay (to not use display/graphics windows) "
write/out "  with parm2 = Yes or No (default) for non-interactive run "
write/out "  with parm3 = Yes or No (default) for executing also long commands"
write/out
write/out Or one by one:
write/out "  @@ verifyX" 
write/out "     " (with X=1,2, ... ,9,10,11,12 and t1,t2,dio)
write/out 
write/out "If you have an RGB display (24 bit per pixel), execute also" -
 verify55.prg
write/out 
write/out "If you have the /midas/demo/data directory containing"
write/out "the Midas demo files, do also `@ superverify' to execute all"
write/out automatic (non-interactive) tutorials.
! 
if p1(1:3) .eq. "XXX" then
   write/out To execute the XXX verification
   write/out enter @@ Xveriall 
   write/out "!Ojo! this test will take time..."
endif
 
