! @(#)sendplot.prg	16.1.1.1 (ESO-DMD) 06/19/01 15:28:49
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION: SENDPLOT.PRG
!.PURPOSE: MIDAS procedure SENDPLOT for sending the plotfile to the hardcopy
!          device being the versatec(s), penplotter(s) or laser printer(s).
!.AUTHOR:  R.H. Warmels, ESO - Garching
!.USE:     execute via the command COPY/GRAPH [device] [meta_file]
!.VERSION: 870402  RHW  date of creation
!.VERSION: 881012  RHW  modification for workstations
!.VERSION: 900116  RHW  assignments for display windows included; defaults 
!.VERSION: 900507  CG   Using environment variables for printers; defaults 
!.VERSION: 901206  KB   {','} business...
!.VERSION: 910322  KB   check IDIDEV(18) against 11
!.VERSION: 910905  RHW  clear P1 before symbol substitution M$SYMBOL
!.VERSION: 920413  KB   `\'  ==>  ` '  with ".."
!.VERSION: 920709  RHW  Rewritten to make in system dependent (all info 
!.                      now retrieved from agldevs.dat
!.VERSION: 930923  RHW  device check for all device; 
!.NOTE:    The procedure either takes the default output device stored in the 
!.         keyword MID$PLOT or the parameter P1.
!.         The device can either be a graphics window, a MIDAS logical name
!.         or a system device name. 
!          Graphical and display windows as well as simple terminal are taken
!          care of the the first part of this procedure. The second part deals
!          with the hardcopy devices.
!
!          All device checking is done the the separate procedure checkdev.prg.
!          A fatal message will be issued if the device is unknown or missing.
!          The file agldevs.dat describes the syntax used internally.
!----------------------------------------------------------------------------
DEFINE/PARAMETER P1 DEFAULT   C     ! get the default device or input from user
DEFINE/PARAMETER P2 {PLCMETA} C     ! take the plot file from PLCMETA
!
! *** local keywords
DEFINE/LOCAL NK/I/1/1  0            ! window number
DEFINE/LOCAL IND/I/1/1 0            ! used for postscript option
DEFINE/LOCAL LEN/I/1/1 0
DEFINE/LOCAL OPT/C/1/1   " "
DEFINE/LOCAL DEV/C/1/1  " "
SET/FORMAT I1
!
! ***** here the part for default copy/graphics from other procedures
IF P1(1:3) .EQ. "DEF" THEN            ! P1 input comes from plot procedure
   WRITE/KEYW P1 {MID$PLOT(1:20)}
   IF MID$PLOT(21:25) .EQ. "NOSPO" THEN
      RETURN
   ENDIF 
ENDIF
!
! *** here the part for the windows
IF P1(1:1) .EQ. "G" THEN                    ! here for a graphics window
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW P1 graph_term
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW P1 graph_wnd{MID$SESS(7:7)}
      ELSE
         DEFINE/LOCAL GID/C/1/1 {P1({NK}:{NK})}
         @ creagra {GID} -999
!        @ creagra {GID}
         WRITE/KEYW P1 graph_wnd{GID}
      ENDIF
   ENDIF
   DEV = "D"

ELSEIF P1(1:1) .EQ. "T" THEN                    ! here for Terminal assignment
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW P1 graph_term
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW P1 grap_wnd{MID$SESS(7:7)}
      ELSE
         DEFINE/LOCAL GID/C/1/1  {P1({NK}:{NK})}
         @ creagra {GID} -999
!        @ creagra {GID}
         WRITE/KEYW P1 graph_wnd{GID}
      ENDIF
   ENDIF
   DEV = "D"

ELSEIF P1(1:1) .EQ. "I" THEN                    ! here for image display
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW P1 image_displ
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW P1 image_wnd{MID$SESS(6:6)}
      ELSE
         DEFINE/LOCAL GID/C/1/1 {P1({NK}:{NK})}
         @ creadisp {GID} -999
!        @ creadisp {GID}
         WRITE/KEYW P1 image_wnd{P1({NK}:>)}
      ENDIF
   ENDIF
   DEV = "D"

ELSEIF P1(1:1) .EQ. "D" THEN                    ! here for image display (I)
   IF IDIDEV(18) .NE. 11 THEN
      WRITE/KEYW P1 image_displ
   ELSE
      NK = M$INDEX(P1,",")+1
      IF NK .LE. 1 THEN
         WRITE/KEYW P1 image_wnd{MID$SESS(6:6)}
      ELSE
         DEFINE/LOCAL GID/C/1/1  {P1({NK}:{NK})}
         @ creadisp {GID} -999
!        @ creadisp {GID}
         WRITE/KEYW P1 image_wnd{P1({NK}:>)}
      ENDIF
   ENDIF
   DEV = "D"
ENDIF
!
IF DEV .EQ. "D" THEN                             ! valid display device ?
   @ checkdev {P1}
   P1 = "{Q1}"                                   
   RUN MID_EXE:COPYGRAP                          ! redraw the meta file
   RETURN
ENDIF
!
! *** here we send the plot to the hardcopy devices
@ checkdev {P1}                                  ! first, check the device
IND = M$INDEX(Q2,".")                            ! look for portrait, landscape
P1 = "{Q1}"
IF IND .NE. 0 THEN
   IF Q2(1:3) .NE. "tkg" .AND. Q2(1:2) .NE. "hp" THEN
      P1 = "{Q1}{Q2({IND}:>)}"
   ENDIF
ENDIF
DEFINE/LOCAL DEVICE/C/1/20 {Q1}                  ! device name
DEFINE/LOCAL TYPE/C/1/20 {Q2}                    ! contains the driver
!
! *** here for checking the harcopy devices
!     first the postscript (filter out the ecolour extension .c)
IF TYPE(1:2) .EQ. "ps" THEN                      ! postscript device
   IF AUX_MODE(1) .LT. 2 THEN                    ! delete previous files
      -DELETE PSCRPLOT.*.
   ELSE
      -DELETE pscrplot*
   ENDIF
!
   IF DEVICE .EQ. "POSTSCRIPT" THEN
       RUN MID_EXE:COPYGRAP
      -RENAME pscrplot.0 {DEVICE}.ps
   ELSE
      IF TYPE(8:9) .EQ. ".c" THEN
         IF AUX_MODE(1) .LT. 2 THEN
              RUN MID_EXE:COPYGRAP
            -RENAME pscrplot.0 {DEVICE}.ps
             WRITE/OUT -
             "*** WARNING: Plot file exists, BUT COLOUR printer not available"
         ELSE
            RUN MID_EXE:COPYGRAP
            -RENAME pscrplot.0 {DEVICE}.ps
            $ {syscoms(1:20)} {DEVICE} {DEVICE}.ps
         ENDIF   

      ELSE                                      ! all other postscript devices
         IF AUX_MODE(1) .LT. 2 THEN
             RUN MID_EXE:COPYGRAP
            -RENAME pscrplot.0 {DEVICE}.ps
            $PRINT/QUEUE={DEVICE} {DEVICE}.ps
         ELSE
             RUN MID_EXE:COPYGRAP
            -RENAME pscrplot.0 {DEVICE}.ps
             $ {syscoms(1:20)} {DEVICE} {DEVICE}.ps
         ENDIF
      ENDIF
   ENDIF
!
ELSEIF TYPE(1:2) .EQ. "hp" THEN                  ! HP penplotter
   IF AUX_MODE(1) .LT. 2 THEN
      -DELETE HPGLPLOT.*.
       RUN MID_EXE:COPYGRAP
       -RENAME hpglplot.0 {DEVICE}.hpgl
       WRITE/OUT "*** WARNING: Plot file exists, BUT PENPLOTTER not available"
   ELSE
      -DELETE hpglplot.*
       RUN MID_EXE:COPYGRAP
       -RENAME hpglplot.0 {DEVICE}.hpgl
       $ {syscoms(1:20)} {DEVICE} {DEVICE}.hpgl
   ENDIF
!	

ELSEIF TYPE(1:2) .EQ. "ra" THEN                  ! rasterizer
   IF AUX_MODE(1) .LT. 2 THEN
      -DELETE VECTOR.*.
       RUN MID_EXE:COPYGRAP
      $SORT/KEY=(POSITION:1,SIZE:1) VECTOR.0 SORTED.TMP
      $VERSATEC /S SORTED.TMP RASTER.TMP
      $SENDV80 RASTER.TMP
      -DELETE *.TMP.*
   ELSE
      -DELETE vector.*
       RUN MID_EXE:COPYGRAP
      $sort -o sorted.tmp +0.0 -0.1 vector.0 
       WRITE/OUT "*** WARNING: Vector file exists, BUT VERSATEC not available"
!      RUN SYS_EXE:versatec.exe -s sorted.tmp raster.tmp
!      RUN SYS_EXE:sendv80.exe raster.tmp
!     -DELETE *.tmp
   ENDIF

ELSEIF TYPE(1:2) .EQ. "tk" THEN                  ! LN03 plotter
   IF DEVICE(1:4) .EQ. "ln03" THEN
      IF AUX_MODE(1) .LT. 2 THEN
         -DELETE LN03PLOT.*.
         RUN MID_EXE:COPYGRAP
         -RENAME ln03plot.0 {DEVICE}.ln03
!        $PRINT/QUEUE={DEVICE} {DEVICE}.ln03
         WRITE/OUT "*** WARNING: Plot file exists, BUT PLOTTER not available"
      ELSE
         -DELETE ln03plot.*
          RUN MID_EXE:COPYGRAP
         -RENAME ln03plot.0 {DEVICE}.ln03
!        $ {syscoms(1:20)} {DEVICE} {DEVICE}.ln03
         WRITE/OUT "*** WARNING: Plot file exists, BUT PLOTTER not available"
      ENDIF
   ENDIF

ENDIF






