! @(#)plotcol.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:28:45
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION  PLOTCOL.PRG
!.PURPOSE         MIDAS procedure to plot a line of an image
!                 execute as @@ PLOTCOL par1 [par2] [par3] [par4] where:
!                 par1 = input frame
!                 par2 = line number (defaulted to 1)
!                 par3 = 1st point,last point on the line (defaulted to 1,npix)
!                        this parameters is read in automatic scaling mode only
!                 par4 = sc_x,sc_y,off_x,off_y (defaults device filling)
!                 or
!                 par4 = line type in overplot mode (OVERPLOT/IMA) 
!
!.AUTHOR          Ch. O
!.VERSION         KB  860911, 900409, 920413
!.VERSION         RHW 861221, 870502, 880224
!.VERSION         RHW 891119  combination of plot and overplot
!.VERSION         RHW 910903  plot/column and overplot/column 
!			      for column plotting
!.VERSION         920224 RHW Offset in x and y included
! ----------------------------------------------------------------------- 
DEFINE/PARAM P1 ? IMA "Enter image:"                ! frame 
DEFINE/PARAM P2 @1                                  ! column number
!define/local cmnd/c/1/20 "{mid$cmnd(1:20)}"		!save initial command
!
IF PLRSTAT(1) .NE. 0.0 .AND. PLRSTAT(2) .NE. 0.0 THEN
   DEFINE/PARAM P3 MANUAL C
ELSE
   DEFINE/PARAM P3 <,> C
   IF P3(1:1) .EQ. "M" THEN
      WRITE/OUT "*** FATAL: X axis not manually set; use SET/GRAPHICS"
      RETURN
   ENDIF
ENDIF
!
!if mid$sess(7:7) .eq. " " .or. mid$sess(7:7) .eq. "-" then
!   create/graphics
!   write/keyw mid$cmnd/c/1/20 "{cmnd(1:20)}"		!reset MID$CMND
!endif
!
WRITE/KEYW  IN_A   {P1}                            ! frame
WRITE/KEYW  INPUTC {P3}                            ! start and end coord.
!
IF MID$CMND(1:1) .EQ. "P" THEN                    ! PLOT/COLUMN 
   DEFINE/PARAM P4 0.,0.,-999,-999 NUM
   @ plscoff {P4}                                 ! get the scales and offsets
   DATTIM = M$TIME()
   RUN MID_EXE:PLOTCOL
ELSE                                              ! OVER/COL
   DEFINE/PARAM P4 0.0 NUM
   WRITE/KEYW  INPUTR/R/1/1 {P4}
   DEFINE/PARAM P5 {PLISTAT(5)} NUM
   DEFINE/LOCAL ITYPE/I/1/1 {PLISTAT(5)}
   WRITE/KEYW  PLISTAT/I/5/1 {P5}
   RUN MID_EXE:PLOTCOL
   WRITE/KEYW  PLISTAT/I/5/1 {ITYPE}
ENDIF
!
WRITE/KEYW PLCDATA/C/1/60  {P1}                    ! name of data
WRITE/KEYW PLCDATA/C/21/20 "FRAME       "          ! type of data structure
@ sendplot
