! @(#)checkdev.prg	16.1.1.1 (ES0-DMD) 06/19/01 15:28:36
!++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!.IDENTIFICATION: checkdev.prg
!.PURPOSE: MIDAS procedure checkdev.prg check the hardcopy device
!.AUTHOR:  R.H. Warmels, ESO - Garching
!.USE:     @ checkdev p1
!          where p1 is the device name that can a MIDAS logical name or a 
!          system device name. 
!          The procedure returns the device and the associated driver in the 
!          keywords Q1 and Q2.
!          The input can be either a MIDAS device name or a system name.
!
!          In case the input is a MIDAS local name, it is first converted to 
!          a system name, using the file /$MIDASHOME/$MIDVERS/monit/devices.sh
!          After having obtained the system device name this name is looked 
!          for in the file /$MIDASHOME/$MIDVERS/systab/ascii/plot/agldevs.dat 
!          which contains all legal devices for the graphics and their drives,
!          and using the MIDAS function M$AGL.
!
!          A fatal message will be issued if the device is unknown or missing.
!          The file agldevs.dat describes the syntax used internally.

!.VERSION: 930503  RHW Creation
!----------------------------------------------------------------------------
DEFINE/PARAMETER P1 LASER  C        ! get the default device or input from user
!
DEFINE/LOCAL PSC/C/1/20 " " all     ! used for postscript option
DEFINE/LOCAL IND/I/1/1 0            ! used for postscript option
DEFINE/LOCAL LEN/I/1/1 0
DEFINE/LOCAL OPT/C/1/1 " "
DEFINE/LOCAL LOWP1/C/1/60 " " all
SET/FORMAT I1
!
! *** MIDAS Logical names
IF P1(1:3) .EQ. "las" .OR. P1(1:3) .EQ. "col" THEN     ! default laser
   IND = M$INDEX(P1,".")
   IF IND .GT. 0 THEN
      IND = IND-1
      PSC = M$UPPER("{P1(1:{IND})}")
      IND = IND+2
      OPT = "{P1({IND}:{IND})}"
      P1  = M$SYMBOL(PSC)                  
      LEN = M$LEN(P1) + 1
      WRITE/KEYW P1/C/{LEN}/2 ".{OPT}"
   ELSE
      if P1(1:3) .eq. "las" then
         write/keyw psc LASER
      elseif P1(1:3) .eq. "col" then
         write/keyw psc COLOUR
      else
         PSC = M$UPPER(P1)
      endif
      P1  = M$SYMBOL(PSC)                  
   ENDIF
!
ELSEIF P1(1:3) .EQ. "sli" THEN                         ! default slide writter 
   P1 = M$SYMBOL("SLIDE")  
!
ELSEIF P1(1:3) .EQ. "pen" THEN                         ! default penplotter
   P1 = M$SYMBOL("PENPLOT")
!
ELSEIF P1(1:3) .EQ. "ver" THEN                        ! default versatec
   P1 = "versa"
!
ELSEIF P1(1:3) .EQ. "nul" THEN                        ! default null device   
   P1 = "null"
ENDIF
!
! *** NOW WE HAVE ALL NAMES CONVERTED INTO DISPLAY or SYSTEM NAMES
! *** They should be listed in MIDASHOME/MIDVERS/systab/ascii/plot/agldevs.dat
! *** lets check that
DEFINE/LOCAL AGLDEV/C/1/40 " " ALL                    ! device plus driver
DEFINE/LOCAL DEVICE/C/1/20 " " ALL                    ! device name
DEFINE/LOCAL DRIVER/C/1/20 " " ALL                    ! driver
DEFINE/LOCAL KK1/I/1/1/ 0
DEFINE/LOCAL KK2/I/1/1/ 0
LOWP1 = M$LOWER(P1)                               ! convert to lowercase
AGLDEV = M$AGL(LOWP1)                                 ! get system+driver
IF AGLDEV(1:1) .EQ. " " THEN
   WRITE/OUT "*** FATAL: Unknown device name or device not available;"
   WRITE/OUT "           consult HELP [PRINTERS]"
   RETURN/EXIT
ENDIF
!
! *** So, now we have a valid devices name
KK1 = M$INDEX(AGLDEV,":") -1                          ! get the device name
WRITE/KEYW DEVICE/C/1/20 {AGLDEV(1:{KK1})}
IND = M$INDEX(DEVICE,".")
IF IND .NE. 0 THEN
   WRITE/KEYW DEVICE/C/{IND}/3 "   "
ENDIF
!
KK2 = M$INDEX(AGLDEV,":") + 1                         ! get the device type
WRITE/KEYW DRIVER/C/1/20 {AGLDEV({KK2}:>)}
!
RETURN {DEVICE} {DRIVER}



