/* @(#)skipnul.c	16.1.1.1 (ES0-DMD) 06/19/01 15:27:20 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT   (c) 1993 European Southern Observatory
.IDENTIFIER  SKIPNUL
.AUTHOR      R.M. van Hees IPG-ESO Garching
.KEYWORDS    plot software, 3-D tables
.LANGUAGE    C
.PURPOSE     skip null values not along a vector, but in opposite direction
             in both vectors or planes
      input: int   nline[2]  dimension of the second axis of both planes.
                             This are the number of points connected by a line,
                             or with the same symbol in the plot table routines
             int   *inull[2] array with NULL flags for both planes
             float *inval[2] array with the data of both planes

  in/output: int   *nconn    dimension of the first axis of both planes.
                             Note that the number of points along this axis
                             has to be equal for both planes
             
     output: int   *nnull    number of NULL values found
             float *outval[2] array with data of both planes without 
                             NULL values.

.COMMENTS    this routine has a different effect on the data (if it contains
             NULL values) than using one of the tbl_readplaneXX routines with
             NULL flag is ON. The tbl_readplaneXX routines reject vectors 
             (lines) from a plane, while this routine removes all values
             at a certain position along the first axes in BOTH planes.

.ENVIRONment MIDAS and AGL
             #include <midas_def.h>     Prototypes for MIDAS interfaces
             #include <plot_def.h>      Symbols used by the PLT interfaces

.VERSION     1.1     19-Dec-1993   added parameter # NULL values found
             1.0     23-Sep-1993   created by R.M. van Hees
------------------------------------------------------------*/
/*
 * Define _POSIX_SOURCE to indicate
 * that this is a POSIX program
 */
#define  _POSIX_SOURCE 1

/*
 * definition of the used functions in this module
 */
#include <midas_def.h>

/*
 * define some macros and constants
 */
#include <plot_def.h>

/*
 * here start the code of the routine
 */
void SKIPNULL( nline, inull, inval, nconn, nnull, outval )
int   nline[2], *inull[2], *nconn, *nnull;
float *inval[2], *outval[2];

{
int    *not_null, *p_null;
float  *pntr1, *pntr2;

register int ii, nc, nl, num_null;

/*
 * initialize the number of NULL values found
 */
num_null = 0;
not_null = (int *) osmmget( *nconn * sizeof(int) );
for ( nc = 0; nc < *nconn; nc++ ) not_null[nc] = TRUE;

/*
 * hunt for NULL values...
 */
for ( ii = 0; ii < PLDIM2; ii++ )
    { p_null = inull[ii];
      for ( nl = 0; nl < nline[ii]; nl++ )
          { for ( nc = 0; nc < *nconn; nc++ )
                { if ( *p_null++ && not_null[nc] ) 
                     { not_null[nc] = FALSE;
                       num_null++;
                     }
                }
          }
    }
/*
 * reject the data with NULL values
 */
for ( ii = 0; ii < PLDIM2; ii++ )
    { pntr1 = inval[ii];
      pntr2 = outval[ii];
      for ( nl = 0; nl < nline[ii]; nl++ )
          { for ( nc = 0; nc < *nconn; nc++ )
                if ( not_null[nc] ) *pntr2++ = *(pntr1+nc);
            pntr1 += *nconn;
          }
    }

*nnull  = num_null;
*nconn -= num_null;

(void) osmmfree( (char *) not_null );
}
