#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stvals.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:23:01 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

 
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.COPYRIGHT: Copyright (c) 1988 European Southern Observatory,
                                         all rights reserved

.LANGUAGE: C

.AUTHOR: K. Banse			ESO _ Garching

.IDENTIFICATION
  Module STVALS

.KEYWORDS
  statistics, mean, min, max

.PURPOSE
  Fortran to C interface: STVALS -> Cstvals

.ALGORITHM
  real work is done in C-routine `Cstvals'

.INPUT/OUTPUT
  call as 
  STVALS(ACTION,A,NAXIS,NPIX,SUBLO,SUBHI,CUTVLS,RSULTS,RESPIX,NOPIX,STAT)

  input par:
  ACTION:      char. exp.  = MIN for min, max calculation
                           = MEAN for above + mean values, std deviation
                           = ALL for above + moments of 2. + 3. order
  A:           R*4 array   array to work on
  NAXIS:       I*4         no. of axis of A (maxium of 3, currently)
  NPIX:        I*4 array   no. of pixels per axis in A
  SUBLO:       I*4 array   start pixels of subframe
  SUBHI:       I*4 array   end pixels of subframe
  CUTVLS:      R*4 array   user supplied cutvalues for subframe

  output par:
  RSULTS:      R*4 array   depending on ACTION, this array contains
                           min, max, mean, sigma, 2-moment, 3-moment,
                           total intensity
  RESPIX:      I*4 array   holds pixel no. of min + max of array
  NOPIX:       I*4         total no. of pixels inside subframe
                           with value in [CUTVLS(1),CUTVLS(2)]
  STAT:        I*4         return status
                           = 0 o.k., otherwise error

.ENVIRONMENT
  Fortran + C
.VERSIONS
  [1.00]	920402:	creation

------------------------------------------------------------------------*/
 
#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STVALS(action,a,naxis,npix,sublo,subhi,cutvls,
                  rsults,respix,nopix,stat)
 
CHARACTER   action;		/* IN: function to do */
fint2c    *naxis;		/* IN: NAXIS of a */
fint2c    *npix;
fint2c    *sublo;
fint2c    *subhi;
fint2c    *respix;
fint2c    *nopix;
fint2c    *stat;
float     *a;
float     *cutvls;
float     *rsults;
#else     /* ==== Generated Code === */
#define STVALS	stvals_
STVALS(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int   n, mylo[3], myhi[3], myrespix[3];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


for (n=0; n<*PARAM(3,11,1,fint2c *); n++)
   {
   mylo[n] =PARAM(5,11,1,fint2c *)[n] - 1;
   myhi[n] =PARAM(6,11,1,fint2c *)[n] - 1;
   }

*PARAM(11,11,1,fint2c *) = Cstvals(C_STRING(1,11,0),PARAM(2,11,1,float *),*PARAM(3,11,1,fint2c *),PARAM(4,11,1,fint2c *),mylo,myhi,PARAM(7,11,1,float *),PARAM(8,11,1,float *),
                  myrespix,PARAM(10,11,1,fint2c *));

for (n=0; n<*PARAM(3,11,1,fint2c *); n++)PARAM(9,11,1,fint2c *)[n] = myrespix[n] + 1;
  ftoc_free(FORmark);    /* <forif> */

}
