#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)f2ciqe.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:22:59 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* +++++++++++++++++++++++++  iqefunc.fc  +++++++++++++++++++++++++++++
.LANGUAGE  C
.AUTHOR    K. Banse		ESO - IPG, Garching
.IDENT     Module iqefunc.fc
.PURPUSE   Fortran to C interface for IQEFUNC
.VERSION   [1.00]  950320
------------------------------------------------------------------------*/
#include <midas_def.h>
#include <proto_gen.h> 
#include <ftoc.h>


#define IQEFUN	iqefun_
ROUTINE IQEFUN(p_img, npix, parm, sdev, stat)
float  *p_img;
fint2c *npix;
float  *parm;
float  *sdev;
fint2c *stat;

{
int  mx,my;
float *p_null;

p_null = (float *) 0;

mx = npix[0]; my = npix[1];
*stat = iqe(p_img, p_null, mx, my, parm, sdev);
}


