#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)extrco.fc	16.1.1.1 (ESO-DMD) 06/19/01 15:22:59 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

 
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.COPYRIGHT: Copyright (c) 1988 European Southern Observatory,
                                         all rights reserved

.LANGUAGE: C

.AUTHOR: K. Banse			ESO _ Garching

.IDENTIFICATION
  Module EXTRCO

.KEYWORDS
  statistics, mean, min, max

.PURPOSE
  Fortran to C interface: EXTRCO -> Cextrco

.ALGORITHM
  real work is done in C-routine `Cextrco'

.INPUT/OUTPUT
  call as 
   EXTCOO(IMNO,STRING,PIXDIM,SUBDIM,SUBLO,SUBHI,STAT)
   EXTCO1(IMNO,STRING,PIXDIM,SUBDIM,SUBLO,STAT)
 
   input par:
   IMNO:      I*4            image no
   STRING:    char.exp.      input string of the form [c1,c2,c3:d1,d2,d3]
   PIXDIM:    I*4            max. no. of dimensions
 
   output par:
   SUBDIM:    I*4            actual dimension of subframe
   SUBLO:     I*4 array      low pixels
   SUBHI:     I*4 array      high pixels
   STAT:      I*4            return status, = 0 o.k., else not o.k.

  and
   XEXTC2(IMNO,STRING,PIXDIM,SUBDIM,SUBLO,SUBHI,STAT)
   XEXTC1(IMNO,STRING,PIXDIM,SUBDIM,SUBLO,STAT)

  all parameters as above, except:
   SUBLO:     R*4 array      low pixels	   (for fractions of frame pixels)
   SUBHI:     R*4 array      high pixels
 
.ENVIRONMENT
  Fortran + C
.VERSIONS
  [1.00]	920403:	creation

001218		last modif

------------------------------------------------------------------------*/
 
#include <ftoc.h>
#include <midas_def.h>

#define MAXDIM  3


/*

*/

#if 0     /* ==== Original Code ==== */
SUBROUTINE ARTIMA(flag,imno,npix,string,size,retimno,stat)

fint2c   *flag;	
fint2c   *imno;	
fint2c   *npix;	
CHARACTER   string;
fint2c   *size;
fint2c   *retimno;
fint2c   *stat;
#else     /* ==== Generated Code === */
#define ARTIMA	artima_
ARTIMA(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

*PARAM(7,7,1,fint2c *) = Fillima(*PARAM(1,7,0,fint2c *),*PARAM(2,7,0,fint2c *),PARAM(3,7,0,fint2c *),STRIPPED_STRING(4,7,0),PARAM(5,7,1,fint2c *),PARAM(6,7,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

/*

*/

#if 0     /* ==== Original Code ==== */
SUBROUTINE EXTCOO(imno,string,pixdim,subdim,sublo,subhi,stat)
 
fint2c   *imno;	
CHARACTER   string;
fint2c   *pixdim;	
fint2c   *subdim;
fint2c   *sublo;
fint2c   *subhi;
fint2c   *stat;
#else     /* ==== Generated Code === */
#define EXTCOO	extcoo_
EXTCOO(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int   n, mydim, mysubdim, mylo[MAXDIM], myhi[MAXDIM];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */



mydim = *PARAM(3,7,1,fint2c *);
*PARAM(7,7,1,fint2c *) = Convcoo(1,*PARAM(1,7,0,fint2c *),STRIPPED_STRING(2,7,0),mydim,&mysubdim,mylo,myhi);

*PARAM(4,7,1,fint2c *) = mysubdim;
for (n=0; n<mydim; n++)			/* move to Fortran counting */
   {PARAM(5,7,1,fint2c *)[n] = mylo[n] + 1;PARAM(6,7,1,fint2c *)[n] = myhi[n] + 1;
   }
  ftoc_free(FORmark);    /* <forif> */

}

/*

*/

#if 0     /* ==== Original Code ==== */
SUBROUTINE XEXTC2(imno,string,pixdim,subdim,sublo,subhi,stat)

fint2c   *imno;
CHARACTER   string;
fint2c   *pixdim;
fint2c   *subdim;
fint2c   *sublo;
float   *subhi;
float   *stat;
#else     /* ==== Generated Code === */
#define XEXTC2	xextc2_
XEXTC2(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int   n, mydim, mysubdim;
float  mylo[MAXDIM], myhi[MAXDIM];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */



mydim = *PARAM(3,7,1,fint2c *);
*PARAM(7,7,1,float *) = XConvcoo(1,*PARAM(1,7,0,fint2c *),STRIPPED_STRING(2,7,0),mydim,&mysubdim,mylo,myhi);

*PARAM(4,7,1,fint2c *) = mysubdim;
for (n=0; n<mydim; n++)                 /* move to Fortran counting */
   {PARAM(5,7,1,fint2c *)[n] = mylo[n] + 1;PARAM(6,7,1,float *)[n] = myhi[n] + 1;
   }
  ftoc_free(FORmark);    /* <forif> */

}

/*

*/

#if 0     /* ==== Original Code ==== */
SUBROUTINE EXTCO1(imno,string,pixdim,subdim,sublo,stat)

fint2c   *imno;
CHARACTER   string;
fint2c   *pixdim;
fint2c   *subdim;
fint2c   *sublo;
fint2c   *stat;
#else     /* ==== Generated Code === */
#define EXTCO1	extco1_
EXTCO1(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int   n, mydim, mysubdim, mylo[MAXDIM], myhi[MAXDIM];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */



mydim = *PARAM(3,6,1,fint2c *);
*PARAM(6,6,1,fint2c *) = Convcoo(0,*PARAM(1,6,0,fint2c *),STRIPPED_STRING(2,6,0),mydim,&mysubdim,mylo,myhi);

*PARAM(4,6,1,fint2c *) = mysubdim;
for (n=0; n<mydim; n++)                 /* move to Fortran counting */PARAM(5,6,1,fint2c *)[n] = mylo[n] + 1;
  ftoc_free(FORmark);    /* <forif> */

}

/*

*/

#if 0     /* ==== Original Code ==== */
SUBROUTINE XEXTC1(imno,string,pixdim,subdim,sublo,stat)

fint2c   *imno;
CHARACTER   string;
fint2c   *pixdim;
fint2c   *subdim;
float   *sublo;
float   *stat;
#else     /* ==== Generated Code === */
#define XEXTC1	xextc1_
XEXTC1(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int   n, mydim, mysubdim;
float  mylo[MAXDIM], myhi[MAXDIM];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */



mydim = *PARAM(3,6,1,fint2c *);
*PARAM(6,6,1,float *) = XConvcoo(0,*PARAM(1,6,0,fint2c *),STRIPPED_STRING(2,6,0),mydim,&mysubdim,mylo,myhi);

*PARAM(4,6,1,fint2c *) = mysubdim;
for (n=0; n<mydim; n++)                 /* move to Fortran counting */PARAM(5,6,1,float *)[n] = mylo[n] + 1;
  ftoc_free(FORmark);    /* <forif> */

}





