#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)clefra.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:22:57 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  CLEFRA.FC  +++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module CLEFRA.FC
.COMMENTS
Contains CLNFRA, CLNTAB, CLNFIT
.AUTHOR         K. Banse        ESO - Garching
.KEYWORDS       tools
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 920331:  created
.VERSION  [1.10] 930110:  add option parameter to CLNFRA, CLNTAB, CLNFIT
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE CLNFRA(infile,outfile,optio)
CHARACTER   infile;     /* IN: input file name                  */
CHARACTER   outfile;    /* OUT: result file name                */
fint2c   *optio;
#else     /* ==== Generated Code === */
#define CLNFRA	clnfra_
CLNFRA(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

char tmpfil[FNAME_LEN];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


CGN_FRAME(STRIPPED_STRING(1,3,0),1,tmpfil,*PARAM(3,3,2,fint2c *));

STRFCOPY(2,3,1,tmpfil);
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE CLNTAB(infile,outfile,optio)
CHARACTER   infile;     /* IN: input file name                  */
CHARACTER   outfile;    /* OUT: result file name                */
fint2c   *optio;
#else     /* ==== Generated Code === */
#define CLNTAB	clntab_
CLNTAB(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

char tmpfil[FNAME_LEN];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


CGN_FRAME(STRIPPED_STRING(1,3,0),3,tmpfil,*PARAM(3,3,2,fint2c *));

STRFCOPY(2,3,1,tmpfil);
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE CLNFIT(infile,outfile,optio)
CHARACTER   infile;     /* IN: input file name                  */
CHARACTER   outfile;    /* OUT: result file name                */
fint2c   *optio;
#else     /* ==== Generated Code === */
#define CLNFIT	clnfit_
CLNFIT(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

char tmpfil[FNAME_LEN];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


CGN_FRAME(STRIPPED_STRING(1,3,0),4,tmpfil,*PARAM(3,3,2,fint2c *));

STRFCOPY(2,3,1,tmpfil);
  ftoc_free(FORmark);    /* <forif> */
}

