/* @(#)setcur.c	16.1.1.1 (ESO-DMD) 06/19/01 15:21:59 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* @(#)setcur.c	8.1.1.2 (ESO-IPG) 11/3/94 08:56:00 */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT   (c) 1994 European Southern Observatory
.LANGUAGE    C
.AUTHOR      K. Banse			IPG-ESO Garching
.KEYWORDS    Image Display, cursor
.IDENTIFIER  SETCUR_C
.PURPOSE     enable/disable fixed cursor(s) of different shapes or 
             programmable cursors and (optionally) set cursor coordinates
.ALGORITHM   use IDI interfaces for interacting with the Image Display
.INPUT/OUTPUT
   call as   SETCUR_C( dsplay, cursno, forma, colo, coords )

  input:
         int display :		Display unit no.
         int cursno  :		Cursor no. = 0, 1 or 2 for both cursors
                     		           = 3 for two independent cursors
         int forma   :		actual cursor form no.
                     		if = -1, make cursors/ROI not visible
                     		if = 99, use last defined cursor form + colour
         int colo    :		cursor colour
         int *coords :		coordinates
         
.RETURNS     nothing
.COMMENTS    none
.ENVIRONment MIDAS
             #include <midas_def.h>   Prototypes for MIDAS interfaces
             #include <idinumd.h>     Global variables for DISPLAY interfaces

.VERSIONS    1.00       940425  F -> C conversion, RvH
.VERSIONS    1.10       941031  cleanup, KB
------------------------------------------------------------*/

/* Define _POSIX_SOURCE to indicate that this is a POSIX program */

#define  _POSIX_SOURCE 1


/* definition of the used functions in this module */

#include <midas_def.h>
#include <idinumd.h>


/*

*/

void SETCUR_C(dsplay,cursno,forma,colo,coords)
int dsplay, cursno, forma, colo, *coords;


{
int form, colr, actvals, knul, ibuff[4];
register int  nr;
int roiid = 0;			/* This parameter is not used by IDI */
int unit = 0;


if (cursno == 2)		/* handle ROIs */
   {
   int   kbuff[8];

   if (forma == 99)     
      {
      (void) SCKRDI("CURSOR",5,4,&actvals,ibuff,&unit,&knul);
      form = ibuff[0];
      colr = ibuff[1];
      }
   else
      {
      form = forma;
      colr = colo;
      }

   if (form < 0)                                     /* clear visibility */
      (void) IIRSRV_C(dsplay,roiid,0);
   else 
      {
      if (form == 2)                                        /* circ. ROI */
         (void) IICINR_C(dsplay,-1,colr,*coords,coords[1],coords[2],
                         coords[3],coords[4],&roiid);
      else                                                  /* rect. ROI */
         (void) IIRINR_C(dsplay,-1,colr,*coords,coords[1],coords[2],
                         coords[3],&roiid);

      (void) IIRSRV_C(dsplay,roiid,1);
      (void) SCKWRI("DAZHOLD",&form,16,1,&unit);
      }
    
   for (nr=0; nr<4; nr++) kbuff[nr] = coords[nr];
   kbuff[4] = kbuff[6] = form;
   kbuff[5] = kbuff[7] = colr;
   (void) SCKWRI("CURSOR",kbuff,1,8,&unit);
   }

else				/* handle single cursor */
   {
   if (forma == 99)     
      {
      (void) SCKRDI("CURSOR",5,4,&actvals,ibuff,&unit,&knul);
      if ( cursno == 0 )
         {
         form = ibuff[0];
         colr = ibuff[1];
         }
      else
         {
         form = ibuff[2];
         colr = ibuff[3];
         }
      }
   else
      {
      form = forma;
      colr = colo;
      }

   (void) IICINC_C(dsplay,-1,cursno,form,colr,*coords,coords[1]);

   if (form >= 0)
      (void) IICSCV_C(dsplay,cursno,1);
   else
      (void) IICSCV_C(dsplay,cursno,0);
    
   ibuff[0] = form;
   ibuff[1] = colr;
   if (cursno == 0)
      {
      (void) SCKWRI("CURSOR",ibuff,5,2,&unit);
      (void) SCKWRI("CURSOR",coords,1,2,&unit);
      }
   else 
      {
      (void) SCKWRI("CURSOR",ibuff,7,2,&unit);
      (void) SCKWRI("CURSOR",coords,3,2,&unit);
      }
   }


/* Update also keyword DAZHOLD */

ibuff[0] = cursno;
ibuff[1] = form;
(void) SCKWRI("DAZHOLD",ibuff,1,2,&unit);
}

/*

*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT   (c) 1994 European Southern Observatory
.IDENTIFIER  CURINF_C
.LANGUAGE    C
.AUTHOR      K. Banse			IPG - ESO Garching
.KEYWORDS    Image Display, cursor
.PURPOSE     enable/disable fixed cursor(s) of different shapes or 
             programmable cursors and (optionally) set cursor coordinates
.ALGORITHM   use IDI interfaces for interacting with the Image Display
.INPUT/OUTPUT
   call as   CURINF_C( dsplay, nocurs, roiflg )

  input:
         int display :		Display unit no.

 output:
         int *nocurs :		Numberof available cursors -> 1 or 2
         int *roiflg :		= 1, if ROI is implemented
         
.RETURNS     nothing

.ENVIRONment MIDAS
#include <midas_def.h>   Prototypes for MIDAS interfaces

.VERSIONS    1.00       940425  F -> C conversion, RvH
.VERSIONS    1.10       941031  cleanup, KB
------------------------------------------------------------*/

void CURINF_C( dsplay, nocurs, roiflg )
int dsplay, *nocurs, *roiflg;

{
int ncap;


/* 40 = code for asking no. of cursors */

(void) IIDQCI_C(dsplay,40,1,nocurs,&ncap);   


/* 60 = code for asking for roi implementation */

(void) IIDQCI_C(dsplay,60,1,roiflg,&ncap);
}
