/* @(#)indisk.c	16.1.1.2 (ESO-DMD) 08/07/01 11:29:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT    (c)  1996   European Southern Observatory
.IDENT        indisk.c
.LANGUAGE     C
.AUTHOR       K. Banse		ESO - Garching
.KEYWORDS     Data conversion, FITS, IHAP
.PURPOSE      Read data file from disk and
              convert it to the internal MIDAS format.
.COMMENT      Formats supported are : FITS 8,16,32,-32,-64, tables
	      groups, etc. 
.VERSION      1.0  000728	KB

 010731		last modification

---------------------------------------------------------------------*/

#ifndef _XOPEN_SOURCE
#define _XOPEN_SOURCE 1
#endif

#include   <stdio.h>
#include   <string.h>
#include   <osfile.h>
#include   <osparms.h>
#include   <fitsfmt.h>
#include   <fitsdef.h>
#include   <midas_def.h>
#include   <fsydef.h>

/*

*/

int main()
{
char  extensio[20], extlabel[20], pfix[100], name[132], text[164];
char  hist, ffmt, *pc, *nfn, catfile[88], resname[48];
char  opt[4], backwflag[2];
char  *nampntr, datpath[192];
extern char DATA_PATH[328];		/* that's inside scs.c (SCSPRO) */

int   fmt, n, dsize, type, nval, istat;
int   mfd, mfdt, popt, fcopt;
int   fid, fidcount, retstat;
int   extcount, Midas_flag, extno, catopt;

BFDEF        *bfdef;

struct filestatus status;

void fillHISTORY();




(void) SCSPRO("INDISK");			/* get into MIDAS env. */
nfn = (char *) 0;
retstat = 0;
extcount = 0;
Midas_flag = 200;		/* to write stuff independent of `popt' */


extno = -999;					/* means full FITS file */
(void) SCKGETC("P1",1,100,&nval,name);		/* read FITS file name */


/* check, if a single extension should be extracted */

if (name[nval-1] == ']')			/* looks like extension */
   {
   n = CGN_JNDEXC(name,'[');
   if (n > 0)				/* Yes - we have an extension */
      {
      float  rdum;
      double ddum;

      name[nval-1] = '\0';		/* separate file name + extension */
      (void) strcpy(extensio,&name[n+1]);
      name[n] = '\0';

      extno = -1;
      if (CGN_CNVT(extensio,1,1,&extno,&rdum,&ddum) < 1)
         {
         extlabel[16] = '\0';

         if (extensio[0] == '"')
            {
            for (n=0; n<16; n++)        /* extensions have max. 16 chars */
               {
               extlabel[n] = extensio[n+1];
               if (extlabel[n] == '"')
                  {
                  extlabel[n] = '\0';
                  break;
                  }
               }
            }
         else
            {
            for (n=0; n<16; n++)        /* extensions have max. 16 chars */
               {
               extlabel[n] = extensio[n];
               if (extlabel[n] == ' ')
                  {
                  extlabel[n] = '\0';
                  break;
                  }
               }
            }

         CGN_UPSTR(extlabel);
         }

      else		/* here for ext. no's. */
         {
         extlabel[0] = '\0';                    /* indicate number */
         if (extno < 0)
            {
            (void)
            sprintf(text,"Warning: Invalid FITS extension ( = %d)\n",extno);
            SCETER(9,text);
            }
         }
      }
   }


(void) SCKGETC("INPUTC",1,100,&nval,pfix);	/* read newfile prefix */
(void) SCKGETC("P3",1,3,&nval,opt);		/* read options */
(void) SCKGETC("P4",1,1,&nval,backwflag);	/* read backwards comp. flag */
(void) SCKGETC("P5",1,80,&nval,catfile);	/* read optional catalog name */
catopt = 0;
if (catfile[0] != '+') catopt = 1;


pc = opt; 
while (*pc) 				/* use capital letters for option */
   {
   if (('a'<=*pc) && (*pc<='z')) *pc += 'A' - 'a';
   pc++;
   }
     

switch (opt[0])
   {				/* check print option    */
   case 'F' : 
    popt = 2; 
    break; 				/* Full print */

   case 'H' : 
    popt = 3; 
    opt[1] = 'N';
    opt[2] = 'N';
    break; 				/* Full print */

   case 'N' : 
    popt = 0; 
    break; 				/* No print */

   case 'S' :				/* Short print */
   default  : 
    popt = 1; 
    opt[0] = 'S';			/* Short print - default */
  }

switch (opt[1]) 
   {				/* check format option */
   case 'N' : 
    fcopt = 0; 
    ffmt = 'N';				/* No creation */
    break;
   case 'F' : 
    fcopt = 1; 
    ffmt = 'F';				/* FP format */
    break;
   case 'O' :				/* Original format */
   default  : 
    fcopt = 1; 
    ffmt = 'O';				/* Original - default */
  }

switch (opt[2]) 
   {				/* check keyword option */
   case 'N' : 
    hist = 'N'; 
    break;				/* No history */
   case 'C' : 
    hist = 'C'; 
    break;				/* Code hierarch keyword */
   case 'A' : 
    hist = 'A'; 
    break;				/* Include hist in empty file */
   case 'Y' :				/* Yes - full history */
   default  : 
    hist = 'Y';				/* Yes-history - default */
  }

fidcount = 0;	/* take also the Midas DATA_PATH into account */
nampntr = name;

open_file:
fid = dopen(nampntr,READ,'S',0);
if (fid < 0)
   {					/* try to open FITS file  */
   if (fidcount < 4)
      {
      n = fidcount*80;
      (void) strncpy(datpath,&DATA_PATH[n],80);
      if (datpath[0] != '^')
         {
         datpath[80] = ' ';
         n = CGN_INDEXC(datpath,' ');
         (void) strcpy(&datpath[n],name);          /* use new path */
         nampntr = datpath;
         fidcount ++;
         goto open_file;
         }
      }

   SCETER(11,"Cannot find FITS file ...");
   }

mfd = -1; mfdt = -1;			/* init FITS business */
fmt = drinit();
if (fmt != FITS) 
   SCETER(9,"Unknown data format of input file...");
    


/* ------------------------------------------ */
/* are we only processing a single extension? */
/* ------------------------------------------ */

if (extno != -999)			/* single FITS extension */
   {		
   int  savpopt;

   savpopt = popt;
   popt = 0;
   xoutname("midd");
   bfdef = hdr_init();			/* decode header */

   if (extno == -1)			/* extension string */
      {
      type = fitsrhd(&mfd,bfdef,&dsize,&mfdt,ffmt,hist,popt,-1);
      if (type < BFITS)
         SCETER(10,"NOT supported FITS format!");
      extcount ++;
      (void) fitssxd(dsize,1);		/* skip data matrix */

      for(;;)			/* loop over all extensions */
         {				/* to get extension no. */
         bfdef = hdr_init();			/* decode header */
         type = fitsrhd(&mfd,bfdef,&dsize,&mfdt,ffmt,hist,popt,-1);
         if (type == EOFITS)
            {
            dclose(fid);
            sprintf(text,"Invalid extension: %s",extensio);
            SCETER(7,text);
            }
         CGN_UPSTR(bfdef->extname);
         if (strcmp(extlabel,bfdef->extname) == 0) break;

         extcount ++;
         (void) fitssxd(dsize,1);		/* skip data matrix */
         }

      extno = extcount;				/* now we have the ext. no. */

      (void) osdseek(fid,0L,FILE_START);	/* rewind file */
      fmt = drinit();
      bfdef = hdr_init();			/* reset internal buffers */
      }


   /* now we have a real extension number */
       
   for (n=0; n<extno; n++)		/* skip extensions before */
      {
      type = fitsrhd(&mfd,bfdef,&dsize,&mfdt,ffmt,hist,popt,-1);
      if (type == EOFITS)
         {
         dclose(fid);
         sprintf(text,"Invalid extension: %s",extensio);
         SCETER(7,text);
         }
      (void) fitssxd(dsize,1);		/* skip data matrix */
      }

   /* bfdef = hdr_init();			// decode header */
   popt = savpopt;
   type = fitsrhd(&mfd,bfdef,&dsize,&mfdt,ffmt,hist,popt,Midas_flag);
   if ((extno == 0) && (type < BFITS))		/* in case it's prime header */
      SCETER(10,"NOT supported FITS format!");

   if (catopt == 1)
      {
      (void) SCKGETC("F$OUTNAM",1,40,&nval,resname);	/* get result name */
      (void) SCCADD(catfile,resname," ");
      }

   if (! fcopt)
      {
      extcount = 1;
      goto close_file;
      }

   if (mfd < 0)
      SCETER(66,"Could not create Midas file");

   (void) sprintf(text,"Extracted from: %s[%d]",nampntr,extno);
   fillHISTORY(mfd,text);			/* update HISTORY  */

   switch (type)
      {
      case ATABLE :                             /* ASCII tables */
       if (dsize > 0) fitsrat(mfd,bfdef,dsize,0);
       (void) strcpy(name,"midd0000.tbl");
       break;

      case BTABLE :                             /* BINARY tables */
       if (dsize > 0) fitsrbt(mfd,bfdef,dsize,0);
       (void) strcpy(name,"midd0000.tbl");
       break;

      case IMAGE  :                             /* IMAGE */
      case BFITS  :                             /* IMAGE */
      case BFITSE :                             /* IMAGE */
       if (dsize > 0) retstat = fitsrdm(mfd,bfdef,dsize,mfdt,ffmt,0);
       if (retstat == NOFITS)
          retstat = -999;
       else 
          retstat = 0;
       (void) strcpy(name,"midd0000.bdf");
       break;

      default:					/* also case UKNOWN */
       dclose(fid);
       (void) sprintf(text,"Unknown FITS extension: %s",extensio);
       SCETER(7,text);
      }

   if ( (strcmp(pfix,"toto") == 0) ||		/* no file name given? */
        (CGN_INDEXC(pfix,FSY_TYPMARK) < 0) )
      {
      if ((type == ATABLE) || (type == BTABLE))
         (void) strcat(pfix,".tbl");
      else
         (void) strcat(pfix,".bdf");
      }
   n = osfrename(name,pfix);
   if (n == 0) 
      {
      (void) sprintf(text,"%s renamed to: %s",name,pfix);
      SCTPUT(text);
      }
   else
      SCETER(6,"Could not rename to final name...");

   extcount = 1;
   backwflag[0] = 'n';		/* avoid any of the stuff in the end ... */
   fcopt = 1;
   goto close_file;
   }



/* ----------------------------------------------------------------- */
/* here the section using the complete FITS file with all extensions */
/* ----------------------------------------------------------------- */

if (xoutname(pfix) != 0) SCETER(6,"Invalid prefix...");

bfdef = hdr_init();			/* decode primary header */
type = fitsrhd(&mfd,bfdef,&dsize,&mfdt,ffmt,hist,popt,Midas_flag);
if (type < BFITS)
   SCETER(10,"NOT supported FITS format!");

if (mfd > -1)
   {
   if (dsize > 0)
      {			/* update HISTORY if image */
      (void) sprintf(text,"Extracted from: %s",nampntr);
      fillHISTORY(mfd,text);

      if (catopt == 1)
         {
         (void) SCKGETC("F$OUTNAM",1,40,&nval,resname);	/* get result name */
         (void) SCCADD(catfile,resname," ");
         }

      retstat = fitsrdm(mfd,bfdef,dsize,mfdt,ffmt,0);	/* also closes file */
      if (retstat == NOFITS)
         {
         retstat = -999;
         goto close_file;
         }
      retstat = 0;
      }
   else
      {
      (void) strcpy(resname,newfn('X',(char *) 0)); 

      if (popt > 0)
         {					/* print what `fitsrhd' does */
         (void) sprintf(text,
             "EPFH  %s         : empty primary FITS header (NAXIS=0)",
             resname);
         SCTPUT(text);
         }

      if (catopt == 1)
         {
         (void) strcat(resname,".bdf");
         (void) SCCADD(catfile,resname," ");
         }
       
      (void) sprintf(text,"Empty primary header of: %s",nampntr);
      fillHISTORY(mfd,text);
      (void) SCFCLO(mfd);		/* close empty primary header file */ 
      }
   }
else
   fitssxd(dsize,0);

extcount ++;			/* count extensions */


extens_loop:				/* go through all extensions */
if (popt == 3) 
   {
   if (extcount == 1)
      (void) sprintf(text,"------------  end of primary header  ------------");
   else
      (void) sprintf(text,"-----------   end of extension # %d   -----------",
                          extcount-1);
   SCTPUT(text);
   SCTPUT(" ");
   }

mfd = -1; mfdt = -1;
bfdef = hdr_init();
type = fitsrhd(&mfd,bfdef,&dsize,&mfdt,ffmt,hist,popt,Midas_flag);
if (type == EOFITS) goto close_file;

if (catopt == 1)
   {
   (void) SCKGETC("F$OUTNAM",1,40,&nval,resname);	/* get result name */
   (void) SCCADD(catfile,resname," ");
   }

if ( (dsize < 1) &&
     ((type == IMAGE) || (type == BFITS) || (type == BFITSE)) )
   {					/* empty header */
   if (popt > 0)
      {					/* print what `fitsrhd' does */
      nfn = newfn('X',(char *) 0); 
      (void) sprintf(text,
          "EFH   %s         : empty FITS header (NAXIS=0)",nfn);
      SCTPUT(text);
      }
       
   if (fcopt)
      {
      (void) 
      sprintf(text,"Empty header extracted from: %s[%d]",nampntr,extcount);
      fillHISTORY(mfd,text);
      (void) SCFCLO(mfd);		/* close empty primary header file */ 
      }
   }

else
   {
   if (fcopt)
      {
      (void) sprintf(text,"Extracted from: %s[%d]",nampntr,extcount);
      fillHISTORY(mfd,text);

      switch (type)
         {
         case ATABLE :				/* ASCII tables */
          fitsrat(mfd,bfdef,dsize,0);
          break;

         case BTABLE :				/* BINARY tables */
          fitsrbt(mfd,bfdef,dsize,0);
          break;

         case IMAGE  :				/* IMAGE */
          retstat = fitsrdm(mfd,bfdef,dsize,mfdt,ffmt,0); 
          if (retstat == NOFITS)
             {
             retstat = -999;
             goto close_file;
             }
          retstat = 0; 
          break;

         default :				/* skip unknown ext. */
          (void) sprintf
          (text,"Warning: Unknown type of FITS extension (%d) skipped",type);
          SCTPUT(text);
          fitssxd(dsize,0);
         }
      }
   else
      fitssxd(dsize,0);			/* skip data section */
   }

extcount ++;
goto extens_loop;


close_file:
dclose(fid); 



if (fcopt == 0) 
   {
   if (popt > 0)
      SCTPUT("Warning: No Midas file(s) created");
   else if (extno == -999)		/* all extensions used */
      {
      (void) sprintf(text,
             "No. of extensions = %d in FITS file: %s",extcount,name);
      SCTPUT(text);
      }
   }
else
   {
   if ((backwflag[0] == 'Y') || (backwflag[0] == 'y'))
      {
      char   namea[132], nameb[132];

      if (extcount == 1)			/* we have single image */
         {
         nfn = newfn('X',(char *)0);               /* get name again */
         (void) strcpy(namea,nfn);
         (void) strcat(namea,".bdf");
         (void) strcpy(nameb,namea);

         n = CGN_INDEXS(namea,"0000");
         nameb[n+3] = '1';                    /* xxxx0000.yyy => xxxx0001.yyy */
         istat = osfrename(namea,nameb);
         if (istat != 0)
            SCETER(7,"osfrename failed...");

         (void) sprintf(text,"Single image is renamed to %s",nameb);
         SCTPUT(text);
         SCTPUT("(to obtain same name as with `intape/fits')");
         }
      }
   }


(void) SCKWRI("MID$INFO",&extcount,4,1,&nval);	/* no. of valid exts */
(void) SCKWRI("OUTPUTI",&retstat,15,1,&nval);
return SCSEPI();
}

/*

*/

void fillHISTORY(imno,text)
int  imno;	/* IN: frame no. */
char *text;	/* IN: HISTORY text */

{
int  iav, n1, n0, e_c, e_d, e_l;

n1 = 1; n0 = 0;
SCECNT("GET",&e_c,&e_d,&e_l);
SCECNT("PUT",&n1,&n0,&n0);              /* disable SC errors */
					/* could be read only frame ... */
if ((int)strlen(text) > 80)
   (void) SCDWRC(imno,"HISTORY",1,text,-1,160,&iav);
else
   (void) SCDWRC(imno,"HISTORY",1,text,-1,80,&iav);

SCECNT("PUT",&e_c,&e_d,&e_l);
}

