/* @(#)fitsrmd.c	16.1.1.1 (ES0-DMD) 06/19/01 15:21:33 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT  (c)  1996  European Southern Observatory
.IDENT      fitsrmd.c
.LAUGUAGE   C
.AUTHOR     P.Grosbol   ESO/IPG
.KEYWORDS   FITS, decode MIDAS descriptor cards
.COMMENT    decodes a FITS HISTORY card in MIDAS format
.VERSION    1.0  1990-Feb-26 : Creation,   PJG 
.VERSION    2.0  1991-Feb-15 : Change structures,   PJG 
.VERSION    2.1  1993-Nov-25 : Update to new SC + prototypes,   PJG 
.VERSION    2.2  1996-Oct-22 : Update to length of descriptor name, PJG 
---------------------------------------------------------------------*/
#include   <fitsfmt.h>
#include   <fitsdef.h>
#include   <midas_def.h>

static     int          mdcc;    /* MIDAS descriptor char. count     */
static     int          mdsc;    /* MIDAS descriptor special char.   */
static     int          mdfe;    /* MIDAS descriptor first element   */
static     int          mdle;    /* MIDAS descriptor last element    */
static     int          mdfw;    /* MIDAS descriptor field width     */
static     int          mdcw;    /* MIDAS descriptor character width */
static     int         mdvpl;    /* MIDAS descriptor values per line */
static     int     mdunit[4];    /* MIDAS descriptor unit            */
static     char          mdt;    /* MIDAS descriptor type            */
static     char   mdn[MXMDN];    /* MIDAS descriptor name            */
static     char      buf[81];    /* buffer for MIDAS C*n descriptor  */

int fitsrmd(mfd,kw,pmdc)
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE       decode FITS HISTORY card in MIDAS format
.RETURN        status - 0:OK, -1:error
---------------------------------------------------------------------*/
int          mfd;                 /* IN:     MIDAS file descriptor   */
KWORD        *kw;                 /* IN:     keyword structure       */
int          *pmdc;               /* IN/OUT: MIDAS desc. count       */
{
  char       c,*ps,*pc;
  int        i,n,k,null;
  float      f;
  double     d;

  if (*pmdc) {
     pc = kw->pcom + 1;
     switch (mdt) {
	case 'S' :
             n = mdvpl * mdfw;
             while (n--) {
                c = *pc++;
                if (mdsc) {
                   if (c=='n') buf[mdcc++] = '\n';
                   else if (c=='\\') buf[mdcc++] = '\\';
                   else buf[mdcc++] = ' ';
                   mdsc = 0;
		}
                else if (c=='\\') { mdsc = 1; continue; }
                     else buf[mdcc++] = c;
                if (1<mdcw && mdcw<=mdcc) {
                   buf[mdcc] = '\0';
                   SCDWRC(mfd,mdn,mdcw,buf,mdfe,1,mdunit);
                   mdcc = 0; mdfe++;
                   if (mdle<mdfe) break;
		}
	     }
             if (mdcw==1) {
                n = (mdle-mdfe+1<mdcc) ? mdle-mdfe+1 : mdcc;
                buf[mdcc] = '\0';
	        SCDWRC(mfd,mdn,mdcw,buf,mdfe,n,mdunit);
                mdcc = 0; mdfe += n;
	     }
             *pmdc = (mdle<mdfe) ? 0 : 1;
	     break;
        case 'I' :
	     for (i=0; i<mdvpl && mdfe<=mdle; i++, mdfe++) {
	         getint(pc,mdfw,&k,&n); pc += mdfw;
	         SCDWRI(mfd,mdn,&n,mdfe,1,mdunit);
             }
             (*pmdc)--; break;
        case 'R' :
	     for (i=0; i<mdvpl && mdfe<=mdle; i++, mdfe++) {
	         getval(pc,mdfw,&k,&d); pc += mdfw; f = d;
	         SCDWRR(mfd,mdn,&f,mdfe,1,mdunit);
             }
             (*pmdc)--; break;
        case 'D' :
	     for (i=0; i<mdvpl && mdfe<=mdle; i++, mdfe++) {
	         getval(pc,mdfw,&k,&d); pc += mdfw;
	         SCDWRD(mfd,mdn,&d,mdfe,1,mdunit);
	     }
             (*pmdc)--; break;
	}
  }
  else {
     pc = kw->val.pc;
     i = 0;
     if (!fldis(&pc,&ps))
	while (*ps && i<MXMDN-1) mdn[i++] = *ps++;
     mdn[i] = '\0';
     fldis(&pc,&ps);
     c = *ps; ps += 2; mdt = '\0';
     getint(ps,72,&i,&mdcw);
     mdfe = (fldiv(&pc,&d)) ? 0 : d;
     mdle = (fldiv(&pc,&d)) ? 0 : d;
     for (i=0; i<4; i++) mdunit[i] = 0;
     switch (c) {
        case 'C' : mdt = 'S'; mdcc = 0; mdsc = 0;
	     SCDWRC(mfd,mdn,mdcw,"",mdle,1,mdunit);
             break;
        case 'I' : mdt = 'I'; i = 0;
             SCDWRI(mfd,mdn,&i,mdle,1,mdunit);
             break;
        case 'R' :
             if (mdcw==4) {
	        mdt = 'R'; f = 0.0;
	        SCDWRR(mfd,mdn,&f,mdle,1,mdunit);
             }
             else if (mdcw==8) {
	             mdt = 'D'; d = 0.0;
	             SCDWRD(mfd,mdn,&d,mdle,1,mdunit);
                  }
             break;
        default  : mdt = '\0'; break;
     }
     i = fldis(&pc,&ps);
     if (dcffmt(ps,&mdvpl,&c,&mdfw,&i))
        SCTPUT("Error: invalid FORTRAN format\n");
     *pmdc = (c!='A') ? (mdle-mdfe)/mdvpl + 1 : 1;
  }
  return 0;
}

