/* @(#)fitsrkw.c	16.1.1.1 (ES0-DMD) 06/19/01 15:21:33 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT  (c)  1993   European Southern Observatory
.IDENT      fitsrkw.c
.LAUGUAGE   C
.AUTHOR     P.Grosbol   ESO/IPG
.KEYWORDS   FITS, decode, keyword
.COMMENT    decode a keyword line in a FITS header
.VERSION    1.0  1988-Dec-10 : Creation,   PJG 
.VERSION    1.1  1990-Jan-02 : Decode hierarchical keywords, PJG 
.VERSION    1.2  1990-Jul-14 : Include small arrays of numbers, PJG 
.VERSION    1.3  1990-Oct-02 : Correct check for COMMENT, PJG 
.VERSION    1.4  1991-Jan-10 : Correct error in hierarch check, PJG 
.VERSION    1.5  1991-Jan-25 : Change include file, PJG 
.VERSION    1.6  1991-Mar-22 : Correct error in 'idx' count, PJG 
.VERSION    1.7  1992-Feb-13 : Define END as comment + correct error, PJG 
.VERSION    1.8  1993-Jul-05 : Correct count error for comment, PJG 
.VERSION    1.9  1993-Sep-03 : Improve hierach kw check, PJG 
.VERSION    2.0  1993-Sep-17 : Change test at end of card, PJG 
.VERSION    2.1  1993-Oct-12 : Save comment when line[8]!='=', PJG 
-----------------------------------------------------------------------*/
#include   <fitsfmt.h>
#include   <fitsdef.h>

static char      *ckw[] = {"HISTORY ",     /* define COMMENT Keywords  */
			   "COMMENT ",
			   "END     ",
			   "        ",(char *) 0
			   };
int fitsrkw(line,kw)
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE       Decode keyword in FITS header
.RETURN        status 0:OK, -1:Illegal keyword syntax
-----------------------------------------------------------------------*/
char         *line;                  /* pointer to start of keyword    */
KWORD          *kw;                  /* pointer to keyword structure   */
{
  char       c, *pc;
  int        idx, n, err, no, i;
  double     d;

				     /* initiate KWORD structure etc.  */
  kw->hkw[0] = (char *) 0; kw->hkn = 0; kw->kvn = 0; kw->fmt = '?';
  kw->pcom = (char *) 0; kw->buf[0] = '\0'; kw->hkb[0] = '\0';
  for (i=0; i<MXKVN; i++) kw->val.d[i] = 0.0;
  idx = 0; n = 0; err = 0; i = 0; no = 0; d= 0.0;

  while (idx<8) {                 /* check and transfer prime keyword  */
    c = *line++; idx++;
    if (' '<=c && c<='`') {                   /* legal character       */
      if ('0'<=c && c<='9') {                 /* number - decode it !  */
	no++; i = 10*i + (c-'0');
      }
      else if (c!=' ') {
	i = 0; no = 0;
      }
    }
    else err = 1;                             /* illegal character     */
    kw->kw[n++] = ('a'<=c && c<='z') ? c+'A'-'a' : c;
  }

  kw->kw[8] = '\0';
  kw->kno = (no && i) ? i : 0;                /* keyword index         */
  if (err) return err;

  n = 0;                                     /* check for COMMENT card */
  while (ckw[n] && strcmp(kw->kw,ckw[n])) n++;
  if (ckw[n]) kw->fmt = 'C';

  if (*line!='=' || kw->fmt=='C') {      /* either hierarch or comment */
     n = 0; i = idx; pc = line;     /* Save full comment part of card  */
     while (i++<80) 
       kw->buf[n++] = ((c = *pc++)<' ' || '~'<c) ? ' ' : c;
     kw->buf[n] = '\0';
     while (n-- && kw->buf[n] == ' ') kw->buf[n] = '\0';
     n++;
     kw->pcom = kw->buf;

     i = idx; pc = line; no = 0;
     do {                                  /* search for hierarch. kw  */
        while (i<80 && *pc==' ') pc++, i++;
        if (80<=i || *pc<'A' || 'z'<*pc || ('Z'<*pc && *pc<'a')) {
	   if (*pc!='=') kw->hkn = 0;
	   break;
	 }
        kw->hkw[kw->hkn++] = &(kw->hkb[no]);
        while (i<80 && *pc!=' ' && *pc!='/' && *pc!='=') {
           c = (*pc<' ' || '~'<*pc) ? '_' : *pc;
           kw->hkb[no++] = ('a'<=c && c<='z') ? c+'A'-'a' : c;
           i++; pc++;
	 }
	kw->hkb[no++] = '\0';
      } while (i<80 && kw->hkn<MXHKW);

     if (!kw->hkn || kw->fmt=='C') {     /* NO hierarch. keyword found */
       kw->hkw[0] = (char *) 0; kw->hkn = 0;
       kw->fmt = 'C';
       n = 0;
       while (kw->buf[n]==' ') n++;
       kw->val.pc = &(kw->buf[n]);
       return err;
     }
     else {
       idx = i; line = pc; i = 0; 
       pc = kw->hkw[kw->hkn-1];
       while (c = *pc++) {	               /* decode number        */
	 if ('0'<=c && c<='9') i = 10*i + (c-'0');
	  else if (c!=' ') i = 0;
       }
       kw->kno = i;
     }
   }

  idx++; line++;                               /* decode keyword value */
  while (*line==' ') {                         /* first char in value  */
    if (79<idx++) return -1;
    line++;
  }

  n = 0;
  if ((c = *line)=='\'') {              /* determine type of parameter */
    kw->fmt = 'S';                                 /* character string */
    line++; idx++;
    while (idx<80 && *line!='\'') {
      kw->buf[n++] = *line++; idx++;
    }
    kw->buf[n++] = '\0';
    kw->val.pc = kw->buf;
  }
  else if (c=='T' || c=='t' || c=='F' || c=='f') { /* logical value    */
    kw->fmt = 'L';
    kw->val.i = (c=='T' || c=='t');
  }
  else if (c=='+' || c=='-' || c=='.' ||
	   c=='e' || c=='E' || c=='d' || c=='D' ||
	   ('0'<=c && c<='9')) {                   /* numeric value    */
    n = getval(line,80-idx,&i,&d);
    while (n--) idx++, line++;
    while (idx<80 && *line==' ') idx++, line++;
    if (idx<80 && *line && *line!=',' && *line!='/') err = 1;
    if (i && *line!=',') { kw->val.i = d; kw->fmt = 'I'; kw->kvn = 1; }
    else {
      kw->val.d[kw->kvn++] = d; kw->fmt = 'R';
      while (*line==',' && kw->kvn<MXKVN) {        /* check for array  */
	line++;
	n = getval(line,72,&i,&d);
	while (n--) idx++, line++;
	while (idx<80 && *line==' ') idx++, line++;
	kw->val.d[kw->kvn++] = d;
      }
      if (*line!=' ' && *line!='/' && MXKVN<=kw->kvn) err = 1;
    }
  }
  else { kw->kvn = 0; kw->fmt = '?'; }                 /* blank field  */

  while (idx++ < 80 && *line++ != '/');                /* find comment */
  while (idx<80 && *line==' ') line++, idx++;
  kw->pcom = &kw->hkb[no];
  while (idx++<80) 
    kw->hkb[no++] = ((c = *line++)<' ' || '~'<c) ? ' ' : c;
  kw->hkb[no] = '\0';
  while (no-- && kw->hkb[no]==' ') kw->hkb[no] = '\0';

  return err;
}
