/* @(#)fitsgpm.c	16.1.1.1 (ES0-DMD) 06/19/01 15:21:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT  (c)  1994  European Southern Observatory
.IDENT      fitsgpm.c
.LAUGUAGE   C
.AUTHOR     P.Grosbol   ESO/IPG
.KEYWORDS   FITS prime data matrix, decode, read
.COMMENT    read the prime data matrix of FITS file and create bdf-file
.VERSION    1.0  1994-Oct-19 : Creation,   PJG 
---------------------------------------------------------------------*/
#include   <filedef.h>             /* File definitions               */
#include   <midas_def.h>           /* MIDAS definitions              */
#include   <fitsfmt.h>             /* General data definitions       */
#include   <fitsdef.h>             /* Basic FITS definitions         */

#define    MXNAME            128   /* Max length of file name        */

#ifdef __STDC__
int fitsgpm(char *fname, char *bname, int *mfd)
#else
int fitsgpm(fname, bname, mfd)
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE    Read prime data matrix in FITS and create a MIDAS bdf-file
.RETURN     error code - 0: OK, -1: cannot open file, -2: wrong format
                                -3: no data matrix, -4: bad output name
---------------------------------------------------------------------*/
char      *fname;             /* IN:  name of input FITS file        */
int       *bname;             /* IN:  name of ouput BDF file         */
int       *mfd;               /* OUT: MIDAS file descriptor          */
#endif
{
  char    name[MXNAME+1];
  int     fid, err, type, dsize, mfdt;
  BFDEF   *bfdef;

  *mfd = -1; mfdt = -1;                 /* initiate variables        */

  fid = dopen(fname, READ, 'S', 0);     /* try to open FITS file     */
  if (fid<0) return -1;                 /* cannot open file          */

  err = drinit();                       /* check file format         */
  if (err != FITS) {                    /* if not FITS format - exit */
     dclose(fid); return -2;
   }

  bfdef = hdr_init();               /* initiate internal structure   */
  err = outname(bname,-1);          /* define name of output file    */
  if (err) {                        /* check if output name is okey  */
     dclose(fid); return -4;
   }
                                    /* read FITS header, create file */
  type  = fitsrhd(mfd, bfdef, &dsize, &mfdt, 'O', 'N', 0);
  if (type < BFITS) {
     dclose(fid); return -2;
   }

  if (dsize < 1) {                  /* check if there are data       */
     dclose(fid); return -3;
   }

  fitsrdm(*mfd, bfdef, dsize, mfdt, 'O', 0);

  if (-1<mfdt) {                    /* delete groups table if any    */
     MID_RETNAM(mfdt, name, MXNAME);
     SCFDEL(name);
   }

  dclose(fid);
  return 0;
}
