/* @(#)report.c	16.1.1.1 (ES0-DMD) 06/19/01 15:20:10 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/


/* 
++++++++++++++++++++++++++++++++++++++++++++++++++

.IDENTIFICATION
  program REPORT			version 2.10	850816
  K. Banse            	      		ESO - Garching
  2.20    870428	2.50	890119		2.55	901016
  2.58    910708

.KEYWORDS
  errors, user problems

.PURPOSE
  save VAX error information, send user comments

.ALGORITHM
   read user gripe from terminal, store it in file report.err.
   the file may then be sent to the IP group via MAIL...

.INPUT/OUTPUT
  the following keywords are used:

  USER/C/1/20		user name
  MID$SESS/C/1/60	user working setup

.VERSIONS
  2.20		use new logical assignments MID_WORK, ...
  2.50		update to Portable MIDAS 
  2.55		add REWIND statements

--------------------------------------------------
*/ 
#include <midas_def.h>

main()

{
      
#include <midas_def.h>
#include <filedef.h>


int  kuni, iav;
int  lincnt, lm, stat;
int  fidin, fidout;

char line[160], user[24];
char midses[24];

static char infil[] = {"middumm.err"};
static char outfil[] = {"report.err"};



/*  get into MIDAS + obtain all necessary info */

SCSPRO("report");
stat = SCKGETC("MID$SESS",1,20,&iav,midses);
stat = SCKGETC("USER",1,20,&iav,user);
strcpy(line,"no");			/* default to no report.err file */
stat = SCKWRC("EDIT",1,line,1,2,&kuni);
lm = 140;
 

/*  open file middumm.err + report.err in current directory */

fidin = osaopen(infil,READ);
if (fidin < 0) 
   {
   printf("Error in reading file `middumm.err'\n\r");
   SCSEPI();
   }

fidout = osaopen(outfil,WRITE);
if (fidout < 0)
   {
   osaclose(fidin);
   printf("Error in creating file `report.err'\n\r");
   SCSEPI();
   }

 
/*  get terminal input + store it in report.err */
 
strcpy(line,"MIDAS problem report (user = ");
strcat(line,user);
strcat(line,"):");
stat = osawrite(fidout,line,strlen(line));
strcpy(line,"---------------- ");
stat = osawrite(fidout,line,strlen(line));

in_loop:
lincnt = osaread(fidin,line,lm);     /* now read from ASCII file */
if (lincnt < 0) 
   goto eof_in;
else if (lincnt == 0)
   goto in_loop;

stat = osawrite(fidout,line,strlen(line));
goto in_loop;

eof_in:
osaclose(fidin);

strcpy(line,"---------------- ");
stat = osawrite(fidout,line,strlen(line));
strcpy(line,"User working setup was: ");
strcat(line,midses);
stat = osawrite(fidout,line,strlen(line));
osaclose(fidout);

strcpy(line,"yes");                    /* indicate success */
SCKWRC("EDIT",1,line,1,3,&kuni);

SCSEPI();
}
