:
# @(#)devices.sh	16.1.1.1 (ESO-IPG) 06/19/01 15:20:00
# -----------------------------------------------------------------------
#
# Bourne shell procedure  devices.sh
# define logical devices names (Environment) for MIDAS on UNIX system
# 901203 CG. New directory structure.
# 910920 KB. Change PRINTER to LPRINT, add PLASER
# 930630 CG. Comments used to generate tapede.alq
#
# -----------------------------------------------------------------------
#
# Tape devices:
# Syntax: <MIDAS_name>=<host>:<device_name> ;export <MIDAS_name> # Comment
#
# Automatic generation of "./prim/help/tapede.alq" for the MIDAS command:
#
#   Midas> HELP [TapeDevices]
#
# if comments follows the convention: 	# :tape:model:capacity/density:location
#
# Example. The entry:
#   tape0:ns0:/dev/nrst17 ;export tape0 # :1/2 inch:6250 dpi:Tape-room
#
# will generate an entry in the "tapede.alq" file as follow: 
#
#   01234567890123456789012345678901234567890123456789012345678901234567890
#   Name      Host      Device         Tape      Cap/Den   Location
#   tape0     ns0       /dev/nrst17    1/2 inch  6250 bpi  Tape-room
#
# If your output does not fit the format you are welcome to modify the script
# "./prim/help/gentapedev.sh"
#
# To generate your "tapede.alq" type in the directory ./prim/help/:
#   % make tapede.alq
#
#tape1=ws1:/dev/nrst12  ;export tape1  #:1/2 in.:6250 bpi:User room 2nd floor
#tape1m=ws1:/dev/nrst12 ;export tape1m #:1/2 in.:1600 bpi:User room 2nd floor
#tape1h=ws1:/dev/nrst20 ;export tape1h #:1/2 in.:6250 bpi:User room 2nd floor
#tape2=ws1:/dev/nrst13  ;export tape2  #:1/2 in.:6250 bpi:User room 2nd floor
#tape2m=ws1:/dev/nrst13 ;export tape2m #:1/2 in.:1600 bpi:User room 2nd floor
#tape2h=ws1:/dev/nrst21 ;export tape2h #:1/2 in.:6250 bpi:User room 2nd floor
#tape3=st6:/dev/nrst16  ;export tape3  #:1/2 in.:6250 bpi:ECF room 4th floor
#tape3m=st6:/dev/nrst8  ;export tape3m #:1/2 in.:1600 bpi:ECF room 4th floor
#tape3h=st6:/dev/nrst16 ;export tape3h #:1/2 in.:6250 bpi:ECF room 4th floor
#tape4=ws0:/dev/nrst19  ;export tape4  #:1/2 in.:6250 bpi:User room 2nd floor
#tape4m=ws0:/dev/nrst11 ;export tape4m #:1/2 in.:1600 bpi:User room 2nd floor
#tape4h=ws0:/dev/nrst19 ;export tape4h #:1/2 in.:6250 bpi:User room 2nd floor
#tape5=ws8:/dev/nrst20  ;export tape5  #:1/2 in.:6250 bpi:SkyLight 4th floor
#tape5m=ws8:/dev/nrst12 ;export tape5m #:1/2 in.:1600 bpi:SkyLight 4th floor
#tape5h=ws8:/dev/nrst20 ;export tape5h #:1/2 in.:6250 bpi:SkyLight 4th floor
#
#tapedat0=ip1:/dev/nrst1 ;export tapedat0 #:DAT/DDS:1.2Gb:IPG room 4th floor
#tapedat1=ws4:/dev/nrst5 ;export tapedat1 #:DAT/DDS:1.2Gb:User room 2nd floor
#tapedat2=ws0:/dev/nrst5 ;export tapedat2 #:DAT/DDS:1.2Gb:User room 2nd floor
#tapedat3=ws8:/dev/nrst0 ;export tapedat3 #:DAT/DDS:1.2Gb:SkyLight room 5th floor
#tapedat4=ns3:/dev/nrst1 ;export tapedat4 #:DAT/DDS:1.2Gb:ECF room 4th floor
#tapedat5=te15:/dev/nrst0 ;export tapedat5 #:DAT/DDS:Comp.8Gb:051 room groud floor
#tapedat6=ws8:/dev/nrst3 ;export tapedat6 #:DAT/DDS:1.2Gb:SKyLight room 5th floor
#tapedat7=ws8:/dev/nrst5 ;export tapedat7 #:DAT/DDS:1.2Gb:SKyLight room 5th floor
#tapedat8=st3:/dev/nrst0 ;export tapedat8 #:DAT/DDS:1.2Gb:Richard's room 5th floor
#
#tape8mm0=ip1:/dev/nrst2 ;export tape8mm0 #:8mm:2.2 Gb:IPG room 4th floor 
#tape8mm1=ip1:/dev/nrst10 ;export tape8mm1 #:8mm:5.0 Gb:IPG room 4th floor 
#tape8mm2=st0:/dev/nrst1 ;export tape8mm2 #:8mm:2.2 Gb:ECF room 4th floor
#tape8mm3=ws8:/dev/nrst2 ;export tape8mm3 #:8mm:2.2 Gb:SkyLight room 5th floor
#tape8mm4=ws4:/dev/nrst4 ;export tape8mm4 #:8mm:5.0 Gb:User room 2nd floor
#tape8mm5=ws5:/dev/nrst1 ;export tape8mm5 #:8mm:2.2 Gb:User room 2nd floor
#tape8mm8=ws8:/dev/nrst1 ;export tape8mm8 #:8mm:5.0 Gb:SkyLight room 5th floor
#
#tapect1=ws0:/dev/nrst8 ;export tapect1	 #:QIC-24:60 Mb:User room 2nd floor
#tapect2=ws5:/dev/nrst0 ;export tapect2   #:QIC-24:60 Mb:User room 2nd floor
#tapect3=ns3:/dev/nrst0 ;export tapect3   #:QIC-150:150 Mb:ECF room 4th floor 
#tapect4=ws2:/dev/nrst8 ;export tapect4   #:QIC-24:60 Mb:User room 2nd floor
#tapect5=ws3:/dev/nrst8 ;export tapect5   #:QIC-24:60 Mb:User room 2nd floor
#tapect8=ip1:/dev/nrst0 ;export tapect8   #:QIC-24:60 Mb:IPG room 4th floor
#
# Printer devices:
# Syntax: <MIDAS_name>=<printer_name> ; export <MIDAS_name>	# comment
#
LPRINT=lp2usr1   ;export LPRINT     # Line printer, 2nd floor, user room
LASER=ps2usr0    ;export LASER      # Postcript B/W, 2nd floor, user room
PLASER=ps2usr0   ;export PLASER     # must be same as LASER
COLOUR=pc2usr0   ;export COLOUR	    # Postcript Color, 2nd floor, user room
SLIDE=sl2usr0    ;export SLIDE      # Chromascript, 2nd floor, user room
PENPLOT=hp2usr0  ;export PENPLOT    # HP plotter, 2nd floor, user room
