/* @(#)sck.c	16.1.1.1 (ES0-DMD) 06/19/01 15:18:57 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++ SC interface module SCK +++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module SCK
.AUTHOR         K. Banse  ESO - Garching
.KEYWORDS       standard interfaces, keyword data base
.ENVIRONMENT    VMS and UNIX
.COMMENTS    
holds SCKGETC, SCKRDx routines

.VERSION  [2.00] 871124:  new version
 
 010421		last modif

-----------------------------------------------------------------------------*/

#include <fileexts.h>



/*

*/

int SCKGETC(key,felem,maxvals,actvals,values)

/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
get data from character keyword and terminate with null (no trailing blanks)
.ALGORITHM
use SCKRDC
.RETURNS
return status ( 0 = ok )
--------------------------------------------------*/

char    *key	/* IN : name of keyword  */;
int felem	/* IN : first data item to be read */;
int maxvals /* IN : no. of elements to get  */;
int  *actvals /* OUT: actual no. of elements returned */;
char    *values /* OUT: buffer for data values */;

{
int   nulo, munit;
int   status;
register int  nr;

register char mychar;


status = SCKRDC(key,1,felem,maxvals,actvals,values,&munit,&nulo);


/* now get rid of trailing blanks/nulls   */

maxvals = (*actvals) - 1;
for (nr=maxvals; nr>=0; nr--)
   {
   mychar = values[nr];
   if ((mychar != ' ') && (mychar != '\0')) 
      {
      *actvals = nr + 1;
      values[nr+1] = '\0';		/* add null terminator  */
      return status;
      }
   }

values[0] = '\0';
*actvals = 0;				/* indicate also in actvals */
return status;
}

/*

*/

int SCKRDC(key,noelm,felem,maxvals,actvals,values,unit,null)

/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
read data from character keyword
.ALGORITHM
straight forward
.RETURNS
return status ( 0 = ok )
--------------------------------------------------*/

char    *key	/* IN : name of keyword  */;
int noelm	/* IN : for char. arrays, CHAR*noelm */;
int felem	/* IN : first data item to be read */;
int maxvals 	/* IN : no. of elements to get  */;
int  *actvals 	/* OUT: actual no. of elements returned */;
char    *values /* OUT: buffer for data values */;
int    *unit  	/* OUT: unit-pointer */;
int  *null	/* OUT: no. of null values in keyword */;

{
int   kk, kunit, status, offset, nulflag;
int   bytelem, noelem, nn, kentry, noval;
register int  nr;

struct  KEY_STRUCT  *keypntr;

long int   modtim;

char  k_typ[4];
register char   *cpntr, *valptr;



/*  find entry in keyword control table  */
 
kentry = MID_FNDKEY(key,k_typ,&bytelem,&noelem,&modtim,&kunit);
if (kentry < 0)
   {
   status = ERR_KEYBAD;
   goto end_of_it;
   }
else if (k_typ[0] != 'C') 
   {
   status = ERR_KEYTYP;
   goto end_of_it;
   }


/*  get info about keyword */

keypntr = KEYALL.KEYNAMES + kentry;

noval = keypntr->NOELEM * keypntr->BYTELEM;	/* real size of keyword */
offset = (felem - 1) * noelm;			/* requested offset */
kk = noval - offset;				/* size available */
kk /= noelm;			 /* no. of elements/values available */


/*  check parameters */

if ( (felem <= 0) || (noelm < 1) || (kk < 1) || (maxvals <= 0) ) 
   {
   status = ERR_OUTLIM;
   goto end_of_it;
   }
	

offset += keypntr->OFFSET;		/* get location in KEY_CWORDS */
if (maxvals < kk) kk = maxvals;		/* minimize ... */
nn = kk * noelm;			/* total no. of bytes to copy */


/* copy data + check for null values at same time  */

nulflag = -1; 			/* nulflag = *null; currently not used */
*null = 0;
cpntr = KCWORDS + offset;
valptr = values;			/* copy pointer */

if (nulflag > -1)
   {
   for (nr=0; nr<nn; nr++)
      {
      /* DISABLE = 118 */
      if (*cpntr == NUL_CVAL) (*null) ++;
      /* ENABLE = 118 */
      *valptr++ = *cpntr++;
      }
   }

else
   {
   for (nr=0; nr<nn; nr++) *valptr++ = *cpntr++;
   }

*unit = kunit;
*actvals = kk;

return ERR_NORMAL;

				/*  here for errors  */
end_of_it:
MID_E1(5,key,status,1);
return status;
}

/*

*/

int SCKRDD(key,felem,maxvals,actvals,values,unit,null)

/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
read data from double keyword
.ALGORITHM
straight forward
.RETURNS
return status ( 0 = ok )
--------------------------------------------------*/

char    *key	/* IN : name of keyword  */;
int  felem	/* IN : first data item to be read */;
int  maxvals /* IN : no. of elements to get  */;
int  *actvals /* OUT: actual no. of elements returned */;
double  *values /* OUT: buffer for data values */;
int    *unit  	/* OUT: unit-pointer */;
int  *null	/* OUT: no. of null values in keyword */;

{
int   kunit, status, offset, nulflag;
int   bytelem, noelem, kentry, noval;
register int  nr;

long int   modtim;

struct  KEY_STRUCT  *keypntr;

char  k_typ[4];

double  *dpntr, *valptr;
 


/*  find entry in keyword control table  */
 
kentry = MID_FNDKEY(key,k_typ,&bytelem,&noelem,&modtim,&kunit);
if (kentry < 0)
   {
   status = ERR_KEYBAD;
   goto end_of_it;
   }
else if (k_typ[0] != 'D') 
   {
   status = ERR_KEYTYP;
   goto end_of_it;
   }


/*  keyname o.k. - check first element + no. of values  */

if ( (felem <= 0) || (felem > noelem) || (maxvals <= 0) ) 
   {
   status = ERR_OUTLIM;
   goto end_of_it;
   }
	

/* get "real" length + offset before 1. value in data block */

keypntr = KEYALL.KEYNAMES + kentry;
nr = felem - 1;

offset = keypntr->OFFSET + nr;
noval = keypntr->NOELEM - nr;
if (noval < maxvals) maxvals = noval;          		/* minimize... */
*unit = kunit;
*actvals = maxvals;


/*  fill input array  */

nulflag = -1; 			/* nulflag = *null; currently not used */
*null = 0;
dpntr = KDWORDS + offset;
valptr = values;			/* copy pointer */

if (nulflag > -1)
   {
   for (nr=0; nr<maxvals; nr++)
      {
      /* DISABLE = 118 */
      if (*dpntr == NUL_DVAL) (*null) ++;
      /* ENABLE = 118 */
      *valptr++ = *dpntr++;
      }
   }

else
   {
   for (nr=0; nr<maxvals; nr++) *valptr++ = *dpntr++;
   }
 
return ERR_NORMAL;
	
				/*  here for errors  */
end_of_it:
MID_E1(5,key,status,1);
return status;
}

/*

*/

int SCKRDI(key,felem,maxvals,actvals,values,unit,null)

/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
read data from integer keyword
.ALGORITHM
straight forward
.RETURNS
return status ( 0 = ok )
--------------------------------------------------*/

char    *key	/* IN : name of keyword  */;
int  felem	/* IN : first data item to be read */;
int  maxvals /* IN : no. of elements to get  */;
int  *actvals /* OUT: actual no. of elements returned */;
int *values /* OUT: buffer for data values */;
int    *unit  	/* OUT: unit-pointer */;
int  *null	/* OUT: no. of null values in keyword */;

{
int   kunit, status, offset, nulflag;
int   bytelem, noelem, kentry, noval;
register int  nr, *ipntr, *valptr;

long int   modtim;

struct  KEY_STRUCT  *keypntr;

char  k_typ[4];



/*  find entry in keyword control table  */
 
kentry = MID_FNDKEY(key,k_typ,&bytelem,&noelem,&modtim,&kunit);
if (kentry < 0)
   {
   status = ERR_KEYBAD;
   goto end_of_it;
   }
else if (k_typ[0] != 'I') 
   {
   status = ERR_KEYTYP;
   goto end_of_it;
   }


/*  keyname o.k. - check first element + no. of values  */

if ( (felem <= 0) || (felem > noelem) || (maxvals <= 0) ) 
   {
   status = ERR_OUTLIM;
   goto end_of_it;
   }


/* get "real" length + offset before 1. value in data block */

keypntr = KEYALL.KEYNAMES + kentry;
nr = felem - 1;

offset = keypntr->OFFSET + nr;
noval = keypntr->NOELEM - nr;
if (noval < maxvals) maxvals = noval;                     /* minimize... */
*unit = kunit;
*actvals = maxvals;


/*  fill input array  */

nulflag = -1; 			/* nulflag = *null; currently not used */
*null = 0;
ipntr = KIWORDS + offset;
valptr = values;			/* copy pointer */

if (nulflag > -1)
   {
   for (nr=0; nr<maxvals; nr++)
      {
      /* DISABLE = 118 */
      if (*ipntr == NUL_IVAL) (*null) ++;
      /* ENABLE = 118 */
      *valptr++ = *ipntr++;
      }
   }

else
   {
   for (nr=0; nr<maxvals; nr++) *valptr++ = *ipntr++;
   }
 
return ERR_NORMAL;
	
				/*  here for errors  */
end_of_it:
MID_E1(5,key,status,1);
return status;
}

/*

*/

int SCKRDR(key,felem,maxvals,actvals,values,unit,null)

/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
read data from character keyword
.ALGORITHM
use lower level routines MID_RDKEYR
.RETURNS
return status ( 0 = ok )
--------------------------------------------------*/

char    *key	/* IN : name of keyword  */;
int  felem	/* IN : first data item to be read */;
int  maxvals /* IN : no. of elements to get  */;
int  *actvals /* OUT: actual no. of elements returned */;
float *values /* OUT: buffer for data values */;
int    *unit  	/* OUT: unit-pointer */;
int  *null	/* OUT: no. of null values in keyword */;

{
int   kunit, status, offset, nulflag;
int   bytelem, noelem, kentry, noval;
register int  nr;

long int   modtim;

struct  KEY_STRUCT  *keypntr;

char  k_typ[4];

register float  *rpntr, *valptr;



/*  find entry in keyword control table  */
 
kentry = MID_FNDKEY(key,k_typ,&bytelem,&noelem,&modtim,&kunit);
if (kentry < 0)
   {
   status = ERR_KEYBAD;
   goto end_of_it;
   }
else if (k_typ[0] != 'R') 
   {
   status = ERR_KEYTYP;
   goto end_of_it;
   }


/*  keyname o.k. - check first element + no. of values  */

if ( (felem <= 0) || (felem > noelem) || (maxvals <= 0) ) 
   {
   status = ERR_OUTLIM;
   goto end_of_it;
   }


/* get "real" length + offset before 1. value in data block */

keypntr = KEYALL.KEYNAMES + kentry;
nr = felem - 1;

offset = keypntr->OFFSET + nr;
noval = keypntr->NOELEM - nr;
if (noval < maxvals) maxvals = noval;                     /* minimize... */
*unit = kunit;
*actvals = maxvals;


/*  fill input array  */

nulflag = -1; 			/* nulflag = *null; currently not used */
*null = 0;
rpntr = KRWORDS + offset;
valptr = values;			/* copy pointer */

if (nulflag > -1)
   {
   for (nr=0; nr<maxvals; nr++)
      {
      /* DISABLE = 118 */
      if (*rpntr == NUL_RVAL) (*null) ++;
      /* ENABLE = 118 */
      *valptr++ = *rpntr++;
      }
   }

else
   {
   for (nr=0; nr<maxvals; nr++) *valptr++ = *rpntr++;
   }
 
return ERR_NORMAL;
	
				/*  here for errors  */
end_of_it:
MID_E1(5,key,status,1);
return status;
}
