/* @(#)sce.c	16.1.1.1 (ESO-DMD) 06/19/01 15:18:56 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++++++++++++++++++ SC interface module SCE +++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module SCE
.AUTHOR         K. Banse 		ESO - Garching
.KEYWORDS       standard interfaces, errors
.ENVIRONMENT    VMS and UNIX
.COMMENTS 
holds SCECNT, SCETER, SCESIG

.VERSION 

 010425		last modif

----------------------------------------------------------------------------*/


#include <fileexts.h>

/*

*/

SCECNT(action,cont,log,disp)

/*+++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
  implement the C-version of the module ERRCNTRL_ST
.ALGORITHM
  straight forward 
.RETURNS
  status	I*4		always = 0
--------------------------------------------------------*/

char   *action	  /* IN : 	GET  or  PUT   */;
int   *cont	  /* IN : pointer to continuation flag */;
int   *log	  /* IN : pointer to log flag */;
int   *disp      /* IN : pointer to display flag */;

{


if ((*action == 'G') || (*action == 'g'))	/*  get ERRO flags  */
   {
   *cont = ERRO_CONT;
   *log = ERRO_LOG;
   *disp = ERRO_DISP;
   }

else					/*  put ERRO flags  */
   {
   ERRO_CONT = *cont;
   ERRO_LOG = *log;
   ERRO_DISP = *disp;
   }
	
return ERR_NORMAL;

}

/*

*/

void SCETER(myerrno,text)

/*+++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
put error no. 'myerrno' into key PROGSTAT + stop execution
.ALGORITHM
straight forward 
.RETURNS
nothing
--------------------------------------------------------*/

int   myerrno	  /* IN: error no.  */;
char   *text	  /* IN: message to display  */;

{
int  unit, inMidas;

char  mytext[82];



if (KEYALL.ORIGIN != -1)		/* we're inside MIDAS */
   {
   inMidas = 1;
   if (KIWORDS[OFF_ERROR+3] != 0)
      {
      MID_ERROR("APP",text,myerrno,1);
      SCTPUT(text);			/* display + log error message */
      }
   else
      MID_ERROR("APP",text,myerrno,0);
   }
else
   {
   inMidas = 0;
   MID_ERROR("APP",text,myerrno,1);
   MID_TPUT(text);                   /* display error message */
   }


if (inMidas == 1)
   {
   unit = 0;				/* so it's set */
   CGN_FILL(mytext,' ',80);
   (void) strncpy(mytext,text,80);
   mytext[80] = '\0';
   (void) SCKWRC("MID$ERRMESS",1,mytext,1,80,&unit);
   }

MID_ABORT(myerrno,100);		/* and disappear like anybody else... */
}

/*

*/

void SCESIG(sys,text,stat)

/*+++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
signal error (high level MID_ERROR)
.ALGORITHM
straight forward 
.RETURNS
nothing
--------------------------------------------------------*/

char   *sys	  /* IN: system from which error emanated */;
char   *text	  /* IN: message to display  */;
int stat	  /* IN: error no.  */;

{

MID_ERROR(sys,text,stat,1);

}
