/* @(#)midkeyc.c	16.1.1.1 (ES0-DMD) 06/19/01 15:18:52 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++++++++++++ Module MIDKEYA +++++++++++++++++++++++++++++++++++++++
.LANGUAGE   C
.IDENTIFICATION  Module MIDKEYA
.AUTHOR   Klaus Banse           ESO - Garching
.KEYWORDS Midas keyword utility routines.
.ENVIRONMENT VMS and UNIX
.COMMENT  
holds xPROMPT, (x=,D,x,R)CI
.VERSION  [3.00] 920129: split off original midkey.c

 010421		last modif

------------------------------------------------------------------------*/
 
 
#include <fileexts.h>
 

/*

*/

int MID_CPROMPT(p_string,noval,carray,nullo)
 
/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
display a prompt string on the terminal + read the user input
.ALGORITHM
use MID_TPRO to display prompt string + get user input as character string
convert this string to relevant data via CGN_CNVT
.RETURNS
status:	I*4		return status
--------------------------------------------------*/

char   *p_string	/* IN : prompt string (null terminated) */;
int   *noval		/* IO : length of expected input */;
char   *carray		/* OUT: input data for type = 3 */;
int   *nullo		/* OUT: no. of null values in input */;
 
{
int   save_val, count;
register int  nr;
 
char	work[96], prombuf[96];

 
save_val = *noval;				/* save noval  */
*noval = 0;					/* init to 0 ...  */

(void) MID_LOG('G',p_string);		/* store prompt string in logfile */
 
 
/*  cut off trailing blanks of prompt + read a line from the terminal */
 
CGN_CUTOFF(p_string,prombuf); 
MID_TPRO(prombuf,work,80);
 
count = (int) strlen(work);		/*  test, if something came in  */
if (count <= 0) return ERR_NODATA;
 

/* do not pass more values than required  */

(void) MID_LOG('G',work);
if (save_val <= count)
   count = save_val;
else
   CGN_FILL(carray,' ',save_val);		  /* fill first with blanks */
*noval = count;

*nullo = 0;
for (nr=0; nr<count; nr++)
   {
   *carray++ = work[nr];
   if (work[nr] == NUL_CVAL) (*nullo) ++;
   }

return ERR_NORMAL;
}

/*

*/

int MID_DPROMPT(p_string,noval,array,nullo)
 
/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
display a prompt string on the terminal + read the user input
.ALGORITHM
use MID_TPRO to display prompt string + get user input as character string
convert this string to relevant data via CGN_CNVT
.RETURNS
status:	I*4		return status
--------------------------------------------------*/

char   *p_string	/* IN : prompt string (null terminated) */;
int   *noval		/* IO : length of expected input */;
double *array		/* OUT: input data */;
int   *nullo		/* OUT: no. of null values in input */;
 
{
int   save_val, status, mm, iar;
register int  nr;

float   rar; 
 
char	work[96], prombuf[96];
 


save_val = *noval;				/* save noval  */
*noval = 0;					/* init to 0 ...  */

(void) MID_LOG('G',p_string);		/* store prompt string in logfile */
 
 
/*  cut off trailing blanks of prompt + read a line from the terminal */
 
CGN_CUTOFF(p_string,prombuf); 
MID_TPRO(prombuf,work,80);
 
mm = (int) strlen(work);		/*  test, if something came in  */
if (mm <= 0) return ERR_NODATA;

(void) MID_LOG('G',work);
mm = CGN_CNVT(work,4,save_val,&iar,&rar,array);
if (mm <= 0) 
   {
   status = ERR_INPINV;			/* conversion error... */
   goto end_of_it;
   }
else
   status = ERR_NORMAL;

*noval = mm;
*nullo = 0;
for (nr=0; nr<mm; nr++)         /* look for null values  */
   {
   if (array[nr] == NUL_DVAL) (*nullo) ++;
   }
 
end_of_it:
if (status != ERR_NORMAL)
   MID_ERROR("MIDAS","MID_DPROMPT",status,0);
 
return status;
}

/*

*/

int MID_IPROMPT(p_string,noval,array,nullo)
 
/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
display a prompt string on the terminal + read the user input
.ALGORITHM
use MID_TPRO to display prompt string + get user input as character string
convert this string to relevant data via CGN_CNVT
.RETURNS
status:	I*4		return status
--------------------------------------------------*/

char   *p_string	/* IN : prompt string (null terminated) */;
int *noval		/* IO : length of expected input */;
int *array		/* OUT: input data */;
int *nullo		/* OUT: no. of null values in input */;
 
{
int   save_val, status, mm;
register int nr;

float     rar; 
double    dar;
 
char	work[96], prombuf[96];

 
save_val = *noval;				/* save noval  */
*noval = 0;					/* init to 0 ...  */

(void) MID_LOG('G',p_string);		/* store prompt string in logfile */
 
 
/*  cut off trailing blanks of prompt + read a line from the terminal */
 
CGN_CUTOFF(p_string,prombuf); 
MID_TPRO(prombuf,work,80);
 
mm = (int) strlen(work);		/*  test, if something came in  */
if (mm <= 0) return ERR_NODATA;

(void) MID_LOG('G',work);
mm = CGN_CNVT(work,1,save_val,array,&rar,&dar);
if (mm <= 0) 
   {
   status = ERR_INPINV;			/* conversion error... */
   goto end_of_it;
   }
else
   status = ERR_NORMAL;

*noval = mm;
*nullo = 0;
for (nr=0; nr<mm; nr++)         /* look for null values  */
   {
   if (array[nr] == NUL_DVAL) (*nullo) ++;
   }
 
end_of_it:
if (status != ERR_NORMAL)
   MID_ERROR("MIDAS","MID_IPROMPT",status,0);
 
return status;
}

/*

*/

int MID_RPROMPT(p_string,noval,array,nullo)
 
/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
display a prompt string on the terminal + read the user input
.ALGORITHM
use MID_TPRO to display prompt string + get user input as character string
convert this string to relevant data via CGN_CNVT
.RETURNS
status:	I*4		return status
--------------------------------------------------*/

char   *p_string	/* IN : prompt string (null terminated) */;
int   *noval		/* IO : length of expected input */;
float  *array		/* OUT: input data */;
int   *nullo		/* OUT: no. of null values in input */;
 
{
int   save_val, status, mm, iar;
register int  nr;

char	work[96], prombuf[96];

double    dar; 

 
save_val = *noval;				/* save noval  */
*noval = 0;					/* init to 0 ...  */

(void) MID_LOG('G',p_string);		/* store prompt string in logfile */
 
 
/*  cut off trailing blanks of prompt + read a line from the terminal */
 
CGN_CUTOFF(p_string,prombuf); 
MID_TPRO(prombuf,work,80);
 
mm = (int) strlen(work);		/*  test, if something came in  */
if (mm <= 0) return ERR_NODATA;

(void) MID_LOG('G',work);
mm = CGN_CNVT(work,2,save_val,&iar,array,&dar);
if (mm <= 0) 
   {
   status = ERR_INPINV;			/* conversion error... */
   goto end_of_it;
   }
else
   status = ERR_NORMAL;

*noval = mm;
*nullo = 0;
for (nr=0; nr<mm; nr++)         /* look for null values  */
   {
   if (array[nr] == NUL_DVAL) (*nullo) ++;
   }
 
end_of_it:
if (status != ERR_NORMAL)
   MID_ERROR("MIDAS","MID_RPROMPT",status,0);
 
return status;
}
