/* @(#)cgne.c	16.1.1.1 (ESO-DMD) 06/19/01 15:18:48 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*+++++++++++++++++++  Module cgne.c  +++++++++++++++++++++++++++++++++++
.LANGUAGE    C
.IDENTIFICATION  Module cgne.c
.AUTHOR  K. Banse                  ESO - Garching
.KEYWORDS
catalogs, MIDAS frames
.COMMENTS
holds clframes, CGN_FRAME, CGN_DSCUPD, CGN_LOGNAM

.VERSION  [1.00] 920325: copied from /midas/`version'/monit/prepl.c

 010425		last modif

-------------------------------------------------------------------------*/

#include <fileexts.h>
#include <fsydef.h>

/*

*/

int  clframes(inname,type,outname)

char    *inname         /* IN: input name */;
int     type		/* IN: type of frame (image, table, ...) */;
char    *outname        /* OUT: new name */;


{
char    cc, csav;
char    catfile[100], cbuf[100];

int   frmno, status, idx, k, n, mm;
int   isu, ioff;

float      roff;

double     doff;




/*  check for &a, &A names   */

if (*inname == '&')
   {
   if ( (inname[1] >= 'A') && (inname[1] <= 'Z') )
      cc = inname[1] + 'a' - 'A';
   else if ( (inname[1] >= 'a') && (inname[1] <= 'z') )
      cc = inname[1];
   else goto same_frame;

   (void) strcpy(outname,"middumm ");
   idx = 7;
   if (KEYALL.ORIGIN != -1)		/* we must be in a Midas session */
      {
      n = OFF_AUX + 11;			/* point to AUX_MODE(12) */
      if (KIWORDS[n] == 123)
         {
         mm = OFF_SESS + 10;			/* point to MIDAS unit */
         outname[7] = KCWORDS[mm++];
         outname[8] = KCWORDS[mm];
         idx = 9;
         }
      }
   outname[idx++] = cc;

   ioff = CGN_INDEXC(&inname[2],'[');
   n = CGN_INDEXC(&inname[2],FSY_TYPMARK);
   if (ioff < 0)
      {
      (void) strcpy(&outname[idx],&inname[2]);
      if (n == -1) (void) strcat(outname,FSY_DEFPNTR[type-1]);
      }
   else
      {
      if (ioff > 0) (void) strncpy(&outname[idx],&inname[2],ioff);
      if ((n == (-1)) || (n > ioff))              /* e.g. &a[2.3:30.3] */
         {
         (void) strcpy(&outname[idx+ioff],FSY_DEFPNTR[type-1]);
         (void) strcat(outname,&inname[2+ioff]);
         }
      else
         (void) strcpy(&outname[idx+ioff],&inname[2+ioff]);
      }
   }


/* continue with other checks only inside MIDAS  */

else if (KEYALL.ORIGIN == -1)
   goto same_frame;


/*  check for #xyz or #xyz_catalog   */

else if (*inname == '#')

   {
   n = CGN_INDEXC(inname,'_');
   if (n > 0)
      {
      k = n - 1;
      (void) strncpy(cbuf,&inname[1],k);
      cbuf[k] = '\0';
      (void) strcpy(catfile,&inname[n+1]);
      }
   else
      {
      mm = OFF_CATINF + type - 1;               /* point to CATALINF(type) */
      n =  KIWORDS[mm];
      mm = OFF_CATAL + (n - 1);
      k =  KIWORDS[OFF_CATINF+10];       /* length of catalog file  */
      (void) strncpy(catfile,&KCWORDS[mm],k);
      catfile[k] = '\0';
      (void) strcpy(cbuf,&inname[1]);
      }

   isu = issub(cbuf);
   if (isu > 0)
      {
      csav = cbuf[isu];                 /* save thtat char. */
      cbuf[isu] = '\0';
      }
   if (CGN_CNVT(cbuf,1,1,&frmno,&roff,&doff) <= 0) goto same_frame;

   status = SCCFND(catfile,frmno,outname);
   if (status != ERR_NORMAL) goto same_frame;
   if (isu > 0)
      {
      cbuf[isu] = csav;
      (void) strcat(outname,&cbuf[isu]);	/* append subframe sepcs */
      }
   }


/*  check for '*'  */

else if (*inname == '*')
   {
   cc = *(inname+1);
   if ((cc == ' ') || (cc == '\0'))
   (void) SCKGETC("IDIMEMC",1,60,&n,outname);
   }

else                                    /*  nothing to do */
   {

same_frame:
   (void) strcpy(outname,inname);
   return (0);
   }

return (1);                     /* Yes, we did replace the file name */
}

/*

*/

int CGN_FRAME(inname,type,outname,optio)

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.RETURNS
 1 if replacement, 0 if same frame returned

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

char  *inname		/* IN: input name */;
int   type		/* IN: type of frame,
			       1 = image, 3 = table, 4 = FIT file */;
char  *outname		/* OUT: new name */;
int   optio		/* IN: = 0, single frame; = 1, whole string */;
 
{
int   klen, kk, mm, iav, status;
register int nj, nr;

char  twork[256], tframe[80], xframe[80];
static char  limc[] = {'+','-','/','*','(',')','.',',','\0'};




if (optio != 1)
   {
   status = clframes(inname,type,outname);
   return(status);
   }

 
/* we have to handle a whole string */

mm = CGN_INDEXC(inname,'#');
if (mm >= 0)
   {
   (void) strcpy(twork,inname);
   klen = (int) strlen(inname);
   kk = mm;

   while (klen > 0)				/* always true ... */
      {
      tframe[0] = '#';
      iav = 1;
      for (nr=mm+1; nr<klen; nr++)
         {
         for (nj=0; nj<9; nj++)
            {
            if (inname[nr] == limc[nj])
               {
               tframe[iav] = '\0';
               goto clean_it;
               }
            }
         tframe[iav++] = inname[nr];
         }

clean_it:
      clframes(tframe,type,xframe);
      (void) strcpy(&twork[kk],xframe);
      iav = (int) strlen(twork);
      (void) strcpy(&twork[iav],&inname[nr]);

      mm = CGN_INDEXC(&inname[nr],'#');
      if (mm < 0) 
         {
         (void) strcpy(outname,twork);
         return(1);		/* all done */
         }

      mm += nr;
      kk = CGN_INDEXC(twork,'#');       /* '#' must also be in `twork' */
      }
   }

else
   (void) strcpy(outname,inname);

return (0);
}

/*

*/

int issub(name)
char  *name;

{
int  nn, mm;



mm = CGN_INDEXC(name,'@');		/* name@123 */
if (mm > 0) return(mm);

mm = CGN_INDEXC(name,' ');
if (mm < 0)
   mm = (int) strlen(name) - 1;
else
   mm --;

if (name[mm] == ']')			/* name[12:34] */
   {
   for (nn=mm; nn>0; nn--)
      {
      if (name[nn] == '[') return(nn);
      }
   }

return(0);
}

/*

*/

/* ++++++++++++++++++++++++++++++++++++++++++++++++++

.COPYRIGHT: Copyright (c) 1987 European Southern Observatory,
                                         all rights reserved
.LANGUAGE: C

.AUTHOR: K.Banse

.IDENTIFICATION
  function CGN_DSCUPD  			version 1.00	880127
  K. Banse    				ESO - Garching
  1.10	    901107	1.20	910617		2.00	920225

.KEYWORDS
  descriptors, copy

.PURPOSE
  a) copy all non-standard descriptors from one frame to another
  b) append line(2) to descr. HISTORY
     if parameter HISTRY != ' '  we use HISTRY
     else we read key HISTORY + append all Pi (MIDAS parameters)

.ALGORITHM
  a) use STDCOP with option 4 or 5 to do the job
  b) if HISTORY_UPDATE == 1, we do not write HISTORY line(s)
 
.INPUT
  use as  stat = CGN_DSCUPD(inno,outno,history)

  inno:  	I*4	 	input frame no.
  outno:  	I*4	 	result frame no.
  history: 	char. exp. 	current addition for descr. HISTORY
    				if blank, get HISTORY from keyword HISTORY
					  and keys P1, P2, ...
  outpt par:
.RETURNS
  always status = 0 for backward compatibility reasons

.VERSIONS
  1.00  	adapted from DSCUPDX (version 1.30)
  1.10  	get contents of Pi explicitely
  2.00  	converted to C
  --------------------------------------------------------------------  */

int CGN_DSCUPD(inno,outno,history)

int   inno,outno;

char       *history;

{
int   flag, iav, ec, el, ed, lzero, lone, nl;
int   unit, stat, n, klen, mm;
int   bytelm, noelm; 
register int  nr;

char   cbuf[100], work[164];
static char  *par[] = {"P1","P2","P3","P4","P5","P6","P7","P8"};

  
 
/*  check, if frames are equal  */

if (inno != outno) 
   {
   stat = SCKRDI("AUX_MODE",4,1,&iav,&flag,&unit,&nl);
   MID_DRESET();
   if (flag == 1) 
      stat = SCDCOP(inno,outno,5," ");
   else
      stat = SCDCOP(inno,outno,4,"HISTORY");
   MID_DRESET();
   }


/*   if descriptor "HISTORY_UPDA" exists and is = 0,
     leave descr. HISTORY untouched                       */
  
SCECNT("GET",&ec,&el,&ed);
lone = 1; lzero = 0;
SCECNT("PUT",&lone,&lzero,&lzero);
stat = SCDRDI(outno,"HISTORY_UPDA",1,1,&iav,&flag,&unit,&nl);
SCECNT("PUT",&ec,&el,&ed);

if ((stat == ERR_NORMAL) && (flag == 0)) return (0);

  
/*  history string is either given as parameter or in keyword HISTORY */


(void) SCDFND(outno,"HISTORY",work,&noelm,&bytelm);
if (work[0] == 'C')
   {
   n = noelm*bytelm;				/* curent size */
   mm = n / 80;
   iav = mm * 80;
   if (iav < n)				/* force multiple of 80 chars. */
      {
      klen = ((mm+1) * 80) - n;
      CGN_FILL(work,' ',klen);
      (void) SCDWRC(outno,"HISTORY",1,work,-1,klen,&unit);
      }
   }

if (*history != ' ') 
   {
   klen = (int) strlen(history);
   if (klen > 160) klen = 160;			/* max. 160 chars. */
   (void) strncpy(work,history,klen);
   }
else
   {
   (void) SCKGETC("HISTORY",1,80,&klen,work);
   (void) SCKRDI("PCOUNT",1,1,&iav,&mm,&unit,&nl);
   for (nr=0; nr<mm; nr++)			    /* append all parameters */
      {
      (void) SCKGETC(par[nr],1,80,&iav,cbuf);
      work[klen++] = ' ';
      n = klen;				/* `flag' follows `klen' */
      klen += iav;
      if (klen < 160) 
         (void) strcpy(&work[n],cbuf);
      else
         {
         klen -= iav;
         break;
         }
      }
   }
 
if (klen < 1)
   return klen;				/* tell that there is a problem... */
else if (klen <= 80)
   n = 80 - klen;
else if (klen <= 160)
   n = 160 - klen;
if (n > 0)
   {
   CGN_FILL(&work[klen],' ',n);
   klen += n;				/*   -> 80 or 160   */
   }


work[klen] = '\0';
(void) SCDWRC(outno,"HISTORY",1,work,-1,klen,&unit);

return (0);
}

/*

*/

void CGN_LOGNAM(infile,outfile,maxout)
/*++++++++++++++++++++++++++++++++++++++++++++++++++
.PURPOSE
 this function translates a filename of the form LOGNAM:file
 to the physical name
.RETURN nothing
--------------------------------------------------*/

char    *infile;        /* IN: input file name                  */
char    *outfile;       /* OUT: result file name                */
int   maxout;   /* IN: max length of outfile            */


{

int  m, n, k, j;

char tempb[200], tempa[64];



n = CGN_INDEXC(infile,':');     /* the ":" is fixed char. for all systems...*/

if ((n < 0) || (n > 60))		/* "blabla:xyz" has a `:' upfront */
   {
   (void) strcpy(outfile,infile);
   k = CGN_INDEXC(outfile,' ');		/* cut off trailing blanks */
   if (k > 0) outfile[k] = '\0';
   return;				/* we're already done... */
   }


(void) strncpy(tempa,infile,n);                /* do not copy the ':'  */
tempa[n] = '\0';

(void) OSY_TRNLOG(tempa,tempb,maxout,&m);
if (m >= maxout)				/* new name too long */
   {
   (void) strncpy(outfile,infile,maxout);
   outfile[maxout] = '\0';
   return;
   }


#if vms
CGN_UPSTR(tempa);                      /* VMS translation => upper case */
#endif

j = strcmp(tempa,tempb);		/* see, if translated at all  */
if (j == 0) 				/* No. So copy input file */
   {
   (void) strcpy(outfile,infile);
   k = CGN_INDEXC(outfile,' ');         /* cut off trailing blanks */
   if (k > 0) outfile[k] = '\0';
   return;                              /* we're already done... */
   }

(void) strcpy(outfile,tempb);


#if vms
if (outfile[m-1] != FSY_DISKEND)
   {
   if (outfile[m-1] != FSY_DIREND) outfile[m++] = FSY_DIREND;
   }
#else

if (outfile[m-1] != FSY_DIREND) outfile[m++] = FSY_DIREND;
#endif


k = CGN_INDEXC(&infile[++n],' '); 	/* check for blanks after the `:' */
if (k > 0)
   {
   (void) strncpy(&outfile[m],&infile[n],k);
   outfile[m+k] = '\0';
   }
else                            /* no blanks before end of string  */
   (void) strcpy(&outfile[m],&infile[n]);
}

