#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)ptd.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:18:04 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT      (c) 1993 European Southern Observatory
.IDENTifier     ptd.fc
.AUTHOR         Rein H. Warmels, ESO-IPG
.KEYWORDS       High level graphics interface, Graphics keywords
.LANGUAGE       C
.PURPOSE        Fortran to C interface for PCAXES and PCFRAMK
.COMMENTS       Module contains interfaces for  PCDATA, PCHIST, and PCTEXT 
.ENVIRONMENT    MIDAS FORTRAN and C standards
.VERSION        1.0 13-Oct-1993 RHW
-----------------------------------------------------------------------------*/
#include <proto_plt.h>
#include <ftoc.h>
#include <midas_def.h>


#define PTDATA	ptdata_
ROUTINE PTDATA(stype,ltype,binmod,x_data,y_data,y_off,nrdata)
fint2c     *stype;	/* IN: symbol type only plotted if ltype equal zero */
fint2c     *ltype;	/* IN: line  type only plotted if ltype equal zero */
fint2c    *binmod;	/* IN: bin mode OFF = 1; ON = 0 */
float     *x_data;	/* IN: x values of the data points */
float     *y_data;	/* IN: y values of the data points */
float      *y_off;	/* IN: y offset of the data */
fint2c    *nrdata;	/* IN: number of data points */
{	
     PCDATA(*stype,*ltype,*binmod,x_data,y_data,*y_off,*nrdata);
}

#define PTHIST	pthist_
ROUTINE PTHIST(nbins,cl,rfr,fopt)
fint2c    *nbins;	/* IN: number of bins */ 
float        *cl;	/* IN: values along the x axis */
float       *rfr;	/* IN: number of data points in bin */
float      *fopt;	/* IN: [1] hist. sel; [2] interl. space; [3] angle */
{	
     PCHIST(*nbins,cl,rfr,fopt);
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE PTTEXT(text,xc,yc,angle,chsiz,ipos)
CHARACTER    text;	/* IN: text string to be drawn */
float         *xc;	/* IN: string position in x */
float         *yc;	/* IN: string position in y */
float      *angle;	/* IN: text angle, in degrees */
float      *chsiz;      /* IN: text expansion factor */
fint2c      *ipos;	/* IN: centering expansion factor (0, 1, 2) */
#else     /* ==== Generated Code === */
#define PTTEXT	pttext_
PTTEXT(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
     PCTEXT(STRIPPED_STRING(1,6,0),*PARAM(2,6,1,float *),*PARAM(3,6,1,float *),*PARAM(4,6,1,float *),*PARAM(5,6,1,float *),*PARAM(6,6,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}










