#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)pta.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:18:04 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT      (c) 1993 European Southern Observatory
.IDENTifier     pta.fc
.AUTHOR         Rein H. Warmels, ESO-IPG
.KEYWORDS       High level graphics interface, Graphics keywords
.LANGUAGE       C
.PURPOSE        Fortran to C interface for PCAXES and PCFRAMK
.COMMENTS       Module contains interfaces for PTAXES and PTFRAM 
.ENVIRONMENT    MIDAS FORTRAN and C standards
.VERSION        1.0 13-Oct-1993 RHW
-----------------------------------------------------------------------------*/
#include <midas_def.h>
#include <ftoc.h>
#include <proto_plt.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE PTAXES(xmnmx,ymnmx,labelx,labely,AGLopt)
float      *xmnmx;	/* IN : minimum and maximum value along the X-axis */
float      *ymnmx;	/* IN : minimum and maximum value along the Y-axis */
CHARACTER  labelx;      /* IN : label along X-axis */
CHARACTER  labely;      /* IN : label along Y-axis */
CHARACTER  AGLopt;      /* IN : AGL option string, see AG_AXES */
#else     /* ==== Generated Code === */
#define PTAXES	ptaxes_
PTAXES(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
     PCAXES(PARAM(1,5,0,float *),PARAM(2,5,0,float *),STRIPPED_STRING(3,5,0),STRIPPED_STRING(4,5,1),
	    STRIPPED_STRING(5,5,2));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE PTFRAM(xwcfram,ywcfram,labelx,labely)
float    *xwcfram;	/* IN : min, max, big, small axes def. of X */
float    *ywcfram;	/* IN : min, max, big, small axes def. of Y */
CHARACTER  labelx;	/* IN : label along the x-axis */
CHARACTER  labely;	/* IN : label along the y-axis */
#else     /* ==== Generated Code === */
#define PTFRAM	ptfram_
PTFRAM(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
     PCFRAM(PARAM(1,4,0,float *),PARAM(2,4,0,float *),STRIPPED_STRING(3,4,0),STRIPPED_STRING(4,4,1));
  ftoc_free(FORmark);    /* <forif> */
}




