/* @(#)iie.c	16.1.1.1 (ESO-DMD) 06/19/01 15:16:50 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/* ----------------------------------------------------------------- */
/* ---------  IIE -------------------------------------------------- */
/* ----------------------------------------------------------------- */

/* file iie.c : contains the following `Escape' routines
*
*   IIEGDB_C      : Get a datablock from IDI server
*   IIESDB_C      : Send a datablock to IDI server
* 
* V 1.0 950203  Klaus Banse - ESO Garching                              

 010514		last modif

*************************************************************************
*/

# include    <idi.h>             
# include    <idistruct.h>
# include    <proto_idi.h>

/*

*/

/************************************************************************
* IIEGDB_C routine : get a block of data from IDI server
*                                                                       *
* synopsis   IIEGDB_C(display,flag,auxid,cbuf,ibuf,rbuf)
*                                                                       *
*       int display;      input    display identifier                   *
*       int flag;	  input    for different options
*				   = 1 for memory data block
*       int auxid;	  input    object id, 
*				   for flag = 1, it's the memory id
*       char *cbuf;       output   char. info
*       int *ibuf;        output   int info
*       float *rbuf;      output   float info
*     
*  the no. of elements in ibuf + rbuf depends upon flag
*  flag = 1,  ibuf 17 elements, rbuf 8 elements
*             corresponding to the IDIMEMC keyword*
************************************************************************/

int IIEGDB_C(display,flag,auxid,cbuf,ibuf,rbuf)

int  display, flag, auxid, *ibuf;
char *cbuf;
float *rbuf;

{

CONF_DATA      *conf;
MEM_DATA       *mem;
ITT_DATA       *itt;
TLIST          *tlist;
GLIST          *glist;

int   mm, i;




if (flag == 1)			/* handle the memory data stuff */
   {
   if (ididev[display].opened == 0) return(DEVNOTOP);

   conf = ididev[display].confptr;
   if (conf->RGBmode == 1)
      {
      if (auxid == 3)
         auxid = conf->overlay;
      else
         auxid = 0;                /* single memory for 3 channels */
      }
   else
      {
      if ((auxid < 0) || (auxid >= conf->overlay)) return(ILLMEMID);
      }

   
   mem = conf->memory[auxid];

   strcpy(cbuf,mem->frame);

   *ibuf++ = mem->load_dir;
   *ibuf++ = mem->sspx;
   *ibuf++ = mem->sspy;
   *ibuf++ = mem->nsx;
   *ibuf++ = mem->nsy;
   *ibuf++ = mem->sfpx;
   *ibuf++ = mem->sfpy;
   *ibuf++ = mem->xscale;
   *ibuf++ = mem->yscale;
   *ibuf++ = mem->xscroll;
   *ibuf++ = mem->yscroll;
   *ibuf++ = mem->zoom;
   *ibuf++ = mem->zoom;			/* same zoom in y */
   *ibuf++ = mem->source;
   itt = mem->ittpntr;
   if (itt != (ITT_DATA *)0)
      *ibuf++ = itt->vis;
   else
      *ibuf++ = 0;
   *ibuf = 0;
   glist = mem->gpntr;
   if ((glist != (GLIST *)0) && (glist->geln > 0))
      *ibuf = 1;
   else 
      {
      tlist = mem->tpntr;
      if ((tlist != (TLIST *)0) && (tlist->teln > 0)) *ibuf = 1;
      }
   ibuf++;
   *ibuf = mem->plane_no;

   for (mm=0; mm<8; mm++) *rbuf++ = mem->rbuf[mm];
   }

else if (flag == 2)			/* get complete setup */
   {
   char  *mytype, cc;

   mytype = cbuf;

   for (i=0; i<MAX_DEV; i++)		/* return w. type and no. */
      {
      if (ididev[i].devname[0] == '\0')
         {
         *mytype++ = ' '; 		/* indicate unused slot */
         *mytype++ = ' '; 
         *ibuf++ = -9;
         *ibuf++ = -9;
         }
      else
         {
         cc = ididev[i].devname[6];
         if (cc == '\0') cc = 'i';		/* nothing = image */
         *mytype++ = cc;
         *mytype++ = ididev[i].devname[5];

         /* printf("IIE: links at %d: %d, %d\n",
            i,ididev[i].link[0],ididev[i].link[1]); */

         *ibuf++ = ididev[i].link[0];		/* also save links */
         *ibuf++ = ididev[i].link[1];
         }
      }
   *mytype = '\0';
   }
         

return(II_SUCCESS);
}

/*

*/

/************************************************************************
* IIESDB_C routine : send a block of data to IDI server
*                                                                       *
* synopsis   IIESDB_C(display,flag,auxid,cbuf,ibuf,rbuf)
*                                                                       *
*       int display;      input    display identifier                   *
*       int flag;         input    for different options
*                                  = 1 for memory data block
*       int auxid;        input    object id,
*                                  for flag = 1, it's the memory id
*                                  for flag = 2, it's ?
*       char *cbuf;       input    char. info
*       int *ibuf;        input    int info
*       float *rbuf;      input    float info
*
*  the no. of elements in ibuf + rbuf depends upon flag
*  flag = 1:  ibuf 17 elements, rbuf 8 elements
*  flag = 2:  ibuf 2 elements
*
************************************************************************/

int IIESDB_C(display,flag,auxid,cbuf,ibuf,rbuf)

int  display, flag, auxid, *ibuf;
char *cbuf;
float *rbuf;

{

CONF_DATA      *conf;
MEM_DATA       *mem;

int   mm;




if (flag == 1)                  /* handle the memory data stuff */
   {
   if (ididev[display].opened == 0) return(DEVNOTOP);

   conf = ididev[display].confptr;
   if ((auxid < 0) || (auxid >= conf->overlay)) return(ILLMEMID);

   mem = conf->memory[auxid];

   strcpy(mem->frame,cbuf);

   ibuf++;			/* we don't need to update mem->load_dir */
   mem->sspx = *ibuf++;
   mem->sspy = *ibuf++;
   mem->nsx = *ibuf++;
   mem->nsy = *ibuf++;
   mem->sfpx = *ibuf++;
   mem->sfpy = *ibuf++;
   mem->xscale = *ibuf++;
   mem->yscale = *ibuf++;

   /* omit mem->xscroll, yscroll, zoom (2*), source, ITTvis and draw-flag  */

   mem->plane_no = *(ibuf+7);


   for (mm=0; mm<8; mm++) mem->rbuf[mm] = *rbuf++;
   }

else if (flag > 100)
   {
   flag -= 100;
   do_misc(display,flag,auxid,cbuf,ibuf,rbuf);
   }


return(II_SUCCESS);
}

