#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)tbm.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:33 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++
.IDENTIFICATION tbm.fc
.LANGUAGE       C
.AUTHOR         J.D. Ponz, F. Ochsenbein (ESO-IPG))
.KEYWORDS       Table system, FORTRAN interface
.ENVIRONMENT    
.VERSION  1.0  	1 Feb 1987     Creation
.VERSION  1.1  	1 Dec 1987     Modification of the calling seq.
.VERSION  1.2  	7 Apr 1988     Add length to the calling seq.
.VERSION  1.3   19-Dec-1990: Simplified
.COMMENTS       FORTRAN 77 to C interface layer.
---------------*/

#include <ftoc.h>
#include <midas_def.h>


#define TBMCON	tbmcon_
ROUTINE TBMCON(tbsel, tdtrue, tdfalse)
/*++++++++++++++++
.PURPOSE F77 to C interface to TCMCON: get some constants
.RETURNS -
-----------------*/
float 	*tbsel;		/* OUT: Flag selection ON  */
double	*tdtrue;	/* OUT: DOUBLE true value  */
double	*tdfalse;	/* OUT: DOUBLE false value */
{
  TCMCON(tbsel, tdtrue, tdfalse);
}

#define TBMNUL	tbmnul_
ROUTINE TBMNUL(tinull, trnull, tdnull)
/*++++++++++++++++
.PURPOSE F77 interface to TCMNUL: get representation of NULL values
.RETURNS -
-----------------*/
fint2c	*tinull;	/* OUT: I*4 NULL value	*/
float	*trnull;	/* OUT: R*4 NULL value	*/
double	*tdnull;	/* OUT: R*8 NULL value	*/
{ 
  TCMNUL(tinull, trnull, tdnull);
}
