#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)tbc.fc	16.1.1.1 (ESO-IPG) 06/19/01 15:16:33 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++
.IDENTIFICATION tbc.fc
.LANGUAGE       C
.AUTHOR         J.D. Ponz, F. Ochsenbein (ESO-IPG))
.KEYWORDS       Table system, FORTRAN interface
.ENVIRONMENT    
.VERSION  1.0  	1 Feb 1987     Creation
.VERSION  1.1  	1 Dec 1987     Modification of the calling seq.
.VERSION  1.2  	7 Apr 1988     Add length to the calling seq.
.VERSION  1.3   16-Oct-1990: Simplified
.COMMENTS       FORTRAN 77 to C interface layer.
.               add TBCPAM MP feb 1992
---------------*/

#include <tbldef.h>
#include <ftoc.h>
#include <ftoc_comm.h>		/* VMR common */
#include <midas_def.h>


#define TBCDEL	tbcdel_
ROUTINE TBCDEL(tid,col,ncol,status)
/*++++++++++++++++
.PURPOSE F77 to C interface used to delete a column in the table. 
.RETURNS -
-----------------*/
fint2c       *tid; 		/* IN : table identifier */
fint2c       *col;		/* IN : array with column numbers */
fint2c       *ncol;		/* OUT: number of columns */
fint2c       *status;		/* OUT: status return */
{
  *status = TCCDEL(*tid,*col,ncol);
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE TBCINI(tid,dtype,alen,form,tunit,label,col,status)
/*++++++++++++++++
.PURPOSE F77 interface to initialize a table column.
.RETURNS -
-----------------*/
fint2c       *tid; 		/* IN : table identifier */
fint2c       *dtype;		/* IN : column type */
fint2c       *alen; 		/* IN : number of items */
CHARACTER   form;		/* IN : column format */
CHARACTER   tunit;		/* IN : column unit */
CHARACTER   label;		/* IN : column label */
fint2c       *col;		/* OUT: column number */
fint2c       *status;		/* OUT: status return */
#else     /* ==== Generated Code === */
#define TBCINI	tbcini_
TBCINI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

  *PARAM(8,8,3,fint2c *) = TCCINI(*PARAM(1,8,0,fint2c *),*PARAM(2,8,0,fint2c *),*PARAM(3,8,0,fint2c *),
	STRIPPED_STRING(4,8,0),
	STRIPPED_STRING(5,8,1),
	STRIPPED_STRING(6,8,2),PARAM(7,8,3,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#define TBCMAP	tbcmap_
ROUTINE TBCMAP(tid,col,index,status)
/*++++++++++++++++
.PURPOSE F77 interface to map a table column.
.RETURNS -
-----------------*/
fint2c       *tid; 	/* IN : table identifier 	*/
fint2c       *col;	/* IN : column number 		*/
flong2c      *index;	/* OUT: column address in VMR 	*/
fint2c       *status;	/* OUT: status return 		*/
{ 
	char *mypntr;

  *status = TCCMAP(*tid,*col,&mypntr);
  *index  = COMMON_INDEX(mypntr);	/* Convert to VMR index	*/
}

#define TBCPAM	tbcpam_
ROUTINE TBCPAM(tid,col,start,asked,mapped,index,status)
/*++++++++++++++++
.PURPOSE F77 interface to map partially a table column.
.RETURNS -
-----------------*/
fint2c       *tid;        /* IN : table identifier        */
fint2c       *col;	/* IN : column number 		*/
fint2c       *start;      /* IN : starting row            */
fint2c       *asked;      /* IN : number of rows to be mapped */
fint2c       *mapped;     /* OUT: number of rows mapped   */
flong2c      *index;	/* OUT: column address in VMR 	*/
fint2c       *status;	/* OUT: status return 		*/
{
        char *mypntr;
   *status = TCCPAM(*tid,*col,*start,*asked,mapped,&mypntr);
   *index  = COMMON_INDEX(mypntr);
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE TBCSEL(tid,text,max_cols,cols,flags,found_cols,status)
/*++++++++++++++++
.PURPOSE F77 interface to TCCSEL (Searchs a set of columns column by names)
.RETURNS -
-----------------*/
fint2c       *tid; 	/* IN : table identifier */
CHARACTER   text;	/* IN : Text of columns, e.g. :RA,DEC(-)*/
fint2c	   *max_cols;	/* IN: Size of cols & flags arrays	*/
fint2c	   *cols;	/* OUT: Column numbers 			*/
fint2c	   *flags;	/* OUT: Column flags (bracketed numbers)*/ 
fint2c       *found_cols;	/* OUT: How many columns were found	*/
fint2c       *status;	/* OUT: status return */
#else     /* ==== Generated Code === */
#define TBCSEL	tbcsel_
TBCSEL(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

  *PARAM(7,7,1,fint2c *) = TCCSEL(*PARAM(1,7,0,fint2c *), STRIPPED_STRING(2,7,0), *PARAM(3,7,1,fint2c *),PARAM(4,7,1,fint2c *),PARAM(5,7,1,fint2c *),PARAM(6,7,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE TBCSER(tid,label,col,status)
/*++++++++++++++++
.PURPOSE F77 interface to search for a column in a table.
.RETURNS -
-----------------*/
fint2c       *tid; 		/* IN : table identifier */
CHARACTER   label;		/* IN : column reference */
fint2c       *col;		/* OUT: column number */
fint2c       *status;		/* OUT: status return */
#else     /* ==== Generated Code === */
#define TBCSER	tbcser_
TBCSER(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

  *PARAM(4,4,1,fint2c *) = TCCSER(*PARAM(1,4,0,fint2c *),STRIPPED_STRING(2,4,0),PARAM(3,4,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#define TBCSRT	tbcsrt_
ROUTINE TBCSRT(tid,nc,col,sortfl,status)
/*++++++++++++++++
.PURPOSE F77 interface to sort a table.
.RETURNS -
-----------------*/
fint2c       *tid; 		/* IN : table identifier */
fint2c       *nc;			/* IN : number of columns */
fint2c       *col;		/* IN : array with column numbers */
fint2c       *sortfl;		/* IN : sort flag (up/down) */
fint2c       *status;		/* OUT: status return */
{
  *status = TCCSRT(*tid,*nc,col,sortfl);
}

#define TBCUNM	tbcunm_
ROUTINE TBCUNM(tid, index, status)
/*++++++++++++++++
.PURPOSE F77 interface to TCCUNM (Unmap a Column)
.RETURNS -
-----------------*/
fint2c       *tid; 	/* IN : table identifier */
fint2c       *index;	/* IN : Value returned by TBCMAP */
fint2c       *status;	/* OUT: status return */
{
  *status = TCCUNM(*tid, (char *)&((&vmr.addr)[*index-1]));
}
