#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)sts.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STS.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STS.FC
.COMMENTS
Module contains layer between the system + text related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 900607:  add SCPSET interface...
.VERSION  [3.00] 901213:  Master file. CG.
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STSEPI()
#else     /* ==== Generated Code === */
#define STSEPI	stsepi_
STSEPI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  va_start(Cargs);       /* <forif> */

	SCSEPI();
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STSPRO(prog)
CHARACTER prog;		/* IN : name of calling program */
#else     /* ==== Generated Code === */
#define STSPRO	stspro_
STSPRO(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    SCSPRO(CHAR_LOC(1,1,0));
  ftoc_free(FORmark);    /* <forif> */
}

#define STPSET	stpset_
ROUTINE STPSET(para,pval,status)
fint2c *para;		/* IN: parameter no. given as a symbol */
fint2c *pval;		/* IN: array with values (may be just one) */
fint2c *status;
{	
    *status = SCPSET(*para,pval);
}

