#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stkb.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STK.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STK.FC
.COMMENTS
Module contains layer between the keyword related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 900316:  fix problems with TEXT_LEN+2
-----------------------------------------------------------------------------*/


#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STKWRC(key,noelm,values,felem,maxvals,kunit,status)
CHARACTER   key;	/* IN : name of keyword */
fint2c	*noelm;		/* IN : for char. array, CHAR*noelm  */
CHARACTER   values;	/* IN : buffer with data values */
fint2c	*felem;		/* IN : first data item to be written */
fint2c	*maxvals;	/* IN : no. of elements to write */
fint2c	*kunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKWRC	stkwrc_
STKWRC(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(7,7,2,fint2c *) = SCKWRC(STRIPPED_STRING(1,7,0),*PARAM(2,7,1,fint2c *),CHAR_LOC(3,7,1),
		     *PARAM(4,7,2,fint2c *),*PARAM(5,7,2,fint2c *),PARAM(6,7,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKWRD(key,values,felem,maxvals,kunit,status)
CHARACTER   key;	/* IN : name of keyword */
double	*values;	/* IN : buffer with data values */
fint2c	*felem;		/* IN : first data item to be written */
fint2c	*maxvals;	/* IN : no. of elements to write */
fint2c	*kunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKWRD	stkwrd_
STKWRD(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(6,6,1,fint2c *) = SCKWRD(STRIPPED_STRING(1,6,0),PARAM(2,6,1,double *),*PARAM(3,6,1,fint2c *),*PARAM(4,6,1,fint2c *),PARAM(5,6,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKWRI(key,values,felem,maxvals,kunit,status)
CHARACTER   key;	/* IN : name of keyword */
fint2c	*values;	/* IN : buffer with data values */
fint2c	*felem;		/* IN : first data item to be written */
fint2c	*maxvals;	/* IN : no. of elements to write */
fint2c	*kunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKWRI	stkwri_
STKWRI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(6,6,1,fint2c *) = SCKWRI(STRIPPED_STRING(1,6,0),PARAM(2,6,1,fint2c *),*PARAM(3,6,1,fint2c *),*PARAM(4,6,1,fint2c *),PARAM(5,6,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKWRR(key,values,felem,maxvals,kunit,status)
CHARACTER   key;	/* IN : name of keyword */
float	*values;	/* IN : buffer with data values */
fint2c	*felem;		/* IN : first data item to be written */
fint2c	*maxvals;	/* IN : no. of elements to write */
fint2c	*kunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKWRR	stkwrr_
STKWRR(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(6,6,1,fint2c *) = SCKWRR(STRIPPED_STRING(1,6,0),PARAM(2,6,1,float *),*PARAM(3,6,1,fint2c *),*PARAM(4,6,1,fint2c *),PARAM(5,6,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}
