#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stka.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STKA.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STKA.FC
.COMMENTS
Module contains layer between the keyword related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 900316:  fix problems with TEXT_LEN+2
.VERSION  [2.80] 920210:  split up sck.fc into sck.fc + scka.fc
-----------------------------------------------------------------------------*/


#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STKFND(key,type,noelem,bytelem,status)
CHARACTER   key;	/* IN:  keyword name  */
CHARACTER   type;	/* OUT: type of key - I, R, C, D or ' '   */
fint2c	*noelem;	/* OUT: no. of elements  */
fint2c	*bytelem;	/* OUT: no. of bytes per element  */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKFND	stkfnd_
STKFND(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

     *PARAM(5,5,2,fint2c *) = SCKFND(STRIPPED_STRING(1,5,0),CHAR_LOC(2,5,1),PARAM(3,5,2,fint2c *),PARAM(4,5,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKINF(npos,field,buf,numbuf,status)
fint2c	*npos;		/* IN : position of keyword */
fint2c	*field;		/* IN :specifies desired info, */
			/*     1 = NAME, 2 = TYPE, 3 = SIZE  */
CHARACTER   buf;	/* OUT : buffer for NAME + TYPE info */
fint2c	*numbuf;	/* IN : max. length of buffer above  */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKINF	stkinf_
STKINF(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(5,5,1,fint2c *) = SCKINF(*PARAM(1,5,0,fint2c *),*PARAM(2,5,0,fint2c *),CHAR_LOC(3,5,0),KEYNAME_LEN,PARAM(4,5,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKPRC(prompt,key,noelm,felem,maxvals,actvals,values,
	kunit,knull,status)
CHARACTER   prompt;	/* IN : prompt string (null terminated) */
CHARACTER   key;	/* IN : name of keyword */
fint2c	*noelm;		/* IN : for character array, CHAR*noelm */
fint2c	*felem;		/* IN : 1st data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
CHARACTER   values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKPRC	stkprc_
STKPRC(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(10,10,3,fint2c *) = SCKPRC(STRIPPED_STRING(1,10,0),STRIPPED_STRING(2,10,1),
		     *PARAM(3,10,2,fint2c *),*PARAM(4,10,2,fint2c *),*PARAM(5,10,2,fint2c *),PARAM(6,10,2,fint2c *),
                     CHAR_LOC(7,10,2),PARAM(8,10,3,fint2c *),PARAM(9,10,3,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKPRD(prompt,key,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   prompt;	/* IN : prompt string (null terminated) */
CHARACTER   key;	/* IN : name of keyword */
fint2c	*felem;		/* IN : 1st data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
double	*values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKPRD	stkprd_
STKPRD(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(9,9,2,fint2c *) = SCKPRD(STRIPPED_STRING(1,9,0),STRIPPED_STRING(2,9,1),
		     *PARAM(3,9,2,fint2c *),*PARAM(4,9,2,fint2c *),PARAM(5,9,2,fint2c *),PARAM(6,9,2,double *),PARAM(7,9,2,fint2c *),PARAM(8,9,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKPRI(prompt,key,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   prompt;	/* IN : prompt string (null terminated) */
CHARACTER   key;	/* IN : name of keyword */
fint2c	*felem;		/* IN : 1st data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
fint2c	*values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKPRI	stkpri_
STKPRI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(9,9,2,fint2c *) = SCKPRI(STRIPPED_STRING(1,9,0),STRIPPED_STRING(2,9,1),
		     *PARAM(3,9,2,fint2c *),*PARAM(4,9,2,fint2c *),PARAM(5,9,2,fint2c *),PARAM(6,9,2,fint2c *),PARAM(7,9,2,fint2c *),PARAM(8,9,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKPRR(prompt,key,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   prompt;	/* IN : prompt string (null terminated) */
CHARACTER   key;	/* IN : name of keyword */
fint2c	*felem;		/* IN : 1st data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
float	*values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKPRR	stkprr_
STKPRR(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(9,9,2,fint2c *) = SCKPRR(STRIPPED_STRING(1,9,0),STRIPPED_STRING(2,9,1),
		     *PARAM(3,9,2,fint2c *),*PARAM(4,9,2,fint2c *),PARAM(5,9,2,fint2c *),PARAM(6,9,2,float *),PARAM(7,9,2,fint2c *),PARAM(8,9,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

