#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stk.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STK.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STK.FC
.COMMENTS
Module contains layer between the keyword related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 900316:  fix problems with TEXT_LEN+2
-----------------------------------------------------------------------------*/


#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STKRDC(key,noelm,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   key;	/* IN : name of keyword  */
fint2c	*noelm;		/* IN : for char. arrays, CHAR*noelm */
fint2c	*felem;		/* IN : first data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get  */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
CHARACTER   values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKRDC	stkrdc_
STKRDC(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
     *PARAM(9,9,2,fint2c *) = SCKRDC(STRIPPED_STRING(1,9,0),*PARAM(2,9,1,fint2c *),*PARAM(3,9,1,fint2c *),*PARAM(4,9,1,fint2c *),PARAM(5,9,1,fint2c *),CHAR_LOC(6,9,1),PARAM(7,9,2,fint2c *),PARAM(8,9,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKRDD(key,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   key;	/* IN : name of keyword  */
fint2c	*felem;		/* IN : first data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get  */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
double  *values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKRDD	stkrdd_
STKRDD(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
     *PARAM(8,8,1,fint2c *) = SCKRDD(STRIPPED_STRING(1,8,0),*PARAM(2,8,1,fint2c *),*PARAM(3,8,1,fint2c *),PARAM(4,8,1,fint2c *),PARAM(5,8,1,double *),PARAM(6,8,1,fint2c *),PARAM(7,8,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKRDI(key,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   key;	/* IN : name of keyword  */
fint2c	*felem;		/* IN : first data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get  */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
fint2c	*values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKRDI	stkrdi_
STKRDI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(8,8,1,fint2c *) = SCKRDI(STRIPPED_STRING(1,8,0),*PARAM(2,8,1,fint2c *),*PARAM(3,8,1,fint2c *),PARAM(4,8,1,fint2c *),PARAM(5,8,1,fint2c *),PARAM(6,8,1,fint2c *),PARAM(7,8,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STKRDR(key,felem,maxvals,actvals,values,kunit,knull,status)
CHARACTER   key;	/* IN : name of keyword  */
fint2c	*felem;		/* IN : first data item to be read */
fint2c	*maxvals;	/* IN : no. of elements to get  */
fint2c	*actvals;	/* OUT: actual no. of elements returned */
float	*values;	/* OUT: buffer for data values */
fint2c	*kunit;		/* OUT: address of unit-pointer */
fint2c	*knull;		/* OUT: no. of null values in keyword */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STKRDR	stkrdr_
STKRDR(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(8,8,1,fint2c *) = SCKRDR(STRIPPED_STRING(1,8,0),*PARAM(2,8,1,fint2c *),*PARAM(3,8,1,fint2c *),PARAM(4,8,1,fint2c *),PARAM(5,8,1,float *),PARAM(6,8,1,fint2c *),PARAM(7,8,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

