#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stia.fc	16.1.1.1 (ESO-IPG) 06/19/01 15:16:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STIA.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STIA.FC
.COMMENTS
Module contains layer between the Image realted FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 880919:  use STRING_FCOPY to get character stuff back
.VERSION  [2.80] 881028:  START + STEP are now double
.VERSION  [2.90] 900316:  fix problems with FNAME_LEN+2
.VERSION  [3.00] 901213:  Master file. CG.
.VERSION  [3.01] 911217:  SCIGET needs to fill temporary strings. CG.
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <ftoc_comm.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STIPUT(name,dattype,iomode,filtype,naxis,npix, 
		start,step,ident,cunit,pntr,no,status)
CHARACTER   name;	/* IN : data frame name */
fint2c	*dattype;	/* IN : data type */
fint2c	*iomode;	/* IN : mode for opening of frame */
fint2c	*filtype;	/* IN : type no: 1 = image, 2 = mask, 3 = table  */
fint2c	*naxis;		/* IN : no of dimensions of the image */
fint2c	*npix;		/* IN : size of each dimension */
double	*start;		/* IN : start coordinates: start is the address of an */
			/*	array of naxis elements */
double	*step;		/* IN : stepsizes : step is the address of an array of*/
			/*	naxis elements */
CHARACTER   ident;	/* IN : ascii identifier of image */
CHARACTER   cunit;	/* IN : unit of each axis (16 char per unit) */
flong2c	*pntr;		/* OUT: pointer to mapped data */
fint2c	*no;		/* OUT: file no. of data frame */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STIPUT	stiput_
STIPUT(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

    char *mypntr;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


    *PARAM(13,13,3,fint2c *) = SCIPUT(STRIPPED_STRING(1,13,0),*PARAM(2,13,1,fint2c *),*PARAM(3,13,1,fint2c *),*PARAM(4,13,1,fint2c *),
		*PARAM(5,13,1,fint2c *),PARAM(6,13,1,fint2c *),PARAM(7,13,1,double *),PARAM(8,13,1,double *),
		STRIPPED_STRING(9,13,1),STRIPPED_STRING(10,13,2),&mypntr,PARAM(12,13,3,fint2c *));
    *PARAM(11,13,3,flong2c *) = COMMON_INDEX(mypntr);
  ftoc_free(FORmark);    /* <forif> */
}

