#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)sti.fc	16.1.1.1 (ESO-IPG) 06/19/01 15:16:32 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STI.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STI.FC
.COMMENTS
Module contains layer between the Image realted FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 880919:  use STRING_FCOPY to get character stuff back
.VERSION  [2.80] 881028:  START + STEP are now double
.VERSION  [2.90] 900316:  fix problems with FNAME_LEN+2
.VERSION  [3.00] 901213:  Master file. CG.
.VERSION  [3.01] 911217:  SCIGET needs to fill temporary strings. CG.
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <ftoc_comm.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STIGET(name,dattype,iomode,filtype,maxdim,naxis,npix,
       start,step,ident,cunit,pntr,no,status)
CHARACTER   name;	/* IN : data frame name */
fint2c	*dattype;	/* IN : data type */
fint2c	*iomode;	/* IN : mode for opening of frame */
fint2c	*filtype;	/* IN : type no: 1 = image, 2 = mask, 3 = table  */
fint2c	*maxdim;	/* IN : maximum number of dimensions */
fint2c	*naxis;		/* OUT: no of dimensions of the image */
fint2c	*npix; 		/* OUT: size of each dimension  */
double	*start;	 	/* OUT: start coordinates: start is the address of an */
			/*      array of naxis elements */
double	*step; 		/* OUT: stepsizes : step is the address of an array of*/
			/*      naxis elements */
CHARACTER   ident;	/* OUT: ascii identifier of image */
CHARACTER   cunit; 	/* OUT: unit of each axis (16 char per unit) */
flong2c *pntr;
fint2c	*no;		/* OUT: file no. of data frame */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STIGET	stiget_
STIGET(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

    char *myident, *mycunit;
    char *mypntr;

    /*
     * Temporary strings need to contain original fortran strings
     */  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    myident=C_STRING(10,14,1);
    mycunit=C_STRING(11,14,2);

    *PARAM(14,14,3,fint2c *) = SCIGET(STRIPPED_STRING(1,14,0),*PARAM(2,14,1,fint2c *),*PARAM(3,14,1,fint2c *),*PARAM(4,14,1,fint2c *),
                 *PARAM(5,14,1,fint2c *),PARAM(6,14,1,fint2c *),PARAM(7,14,1,fint2c *),PARAM(8,14,1,double *),PARAM(9,14,1,double *),myident,mycunit,&mypntr,PARAM(13,14,3,fint2c *));
    STRFCOPY(10,14,1,myident);
    STRFCOPY(11,14,2,mycunit);
    *PARAM(12,14,3,flong2c *) = COMMON_INDEX(mypntr);
  ftoc_free(FORmark);    /* <forif> */
}
