#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stfx.fc	16.1.1.1 (ESO-IPG) 06/19/01 15:16:31 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STFX.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STFX
.COMMENTS
Module contains layer between STFXMP and SCFXMP
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 920302:  creation
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <ftoc_comm.h>
#include <midas_def.h>


#define STFXMP	stfxmp_
ROUTINE STFXMP(nopix,datform,pntr,status)
fint2c	*nopix; 	/* IN: no. of pixels we need memory for */
fint2c	*datform; 	/* IN: data format of */
flong2c *pntr;		/* OUT: pointer to mapped data */
fint2c	*status;
{
    char *mypntr;

    *status = SCFXMP(*nopix,*datform,&mypntr);
    *pntr = COMMON_INDEX(mypntr);
}

#define STFYMP	stfymp_
ROUTINE STFYMP(nopix,datform,imno,pntr,status)
fint2c	*nopix; 	/* IN: no. of pixels we need memory for */
fint2c	*datform; 	/* IN: data format of */
fint2c	*imno;		/* OUT: file id */
flong2c *pntr;		/* OUT: pointer to mapped data */
fint2c	*status;
{
    char *mypntr;

    *status = SCFYMP(*nopix,*datform,imno,&mypntr);
    *pntr = COMMON_INDEX(mypntr);
}
