#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stfe.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:31 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STFE.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STFE.FC
.COMMENTS
Module contains layer between the frame related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880415:  modified new version - the last one
.VERSION  [2.70] 890119:  add SZCFRNM
.VERSION  [2.80] 900316:  fix problem with FNAME_LEN+2 ...
.VERSION  [3.00] 901213:  Master file. CG.
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <ftoc_comm.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STFINF(name,fno,ibuf,status)
CHARACTER   name;	/* IN: name of data frame */
fint2c *fno;		/* IN: specify desired info,*/
			/*     0 = FCT_number	*/
			/*     1 = version_no.,file_type,FCB.SWPSHORT */
			/*         FCB.SWPLONG,FCB.FLOTFMT */
			/*	2 = nobyte,format,pixpbl,stblok,lastblk */
			/*	3 = FCB.PTRLDB,LEXBDF,PEXBDF,ENDLDB, */
			/*	INDLDB,DBEGIN,DFILLED,DSIZE */
			/*	99 = just check, if frame exists */
fint2c *ibuf;		/* OUT: buffer with desired info  */
fint2c *status;
#else     /* ==== Generated Code === */
#define STFINF	stfinf_
STFINF(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(4,4,1,fint2c *) = SCFINF(STRIPPED_STRING(1,4,0),*PARAM(2,4,1,fint2c *),PARAM(3,4,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STFNAM(fno,name,namlen,status)
fint2c *fno;            /* IN : no. of data frame */
CHARACTER   name;       /* OUT: name of data frame */
fint2c *namlen; 	/* IN: max. length of name */
fint2c *status;
#else     /* ==== Generated Code === */
#define STFNAM	stfnam_
STFNAM(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(4,4,1,fint2c *) = SCFNAME(*PARAM(1,4,0,fint2c *),CHAR_LOC(2,4,0),*PARAM(3,4,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

