#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)ste.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:31 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STE.FC +++++++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STE.FC
.COMMENTS
Module contains layer between the error related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [2.70] 900316:  modfied new version - the FNAME_LEN+2 ...
.VERSION  [3.00] 901213:  Master file. CG.
-----------------------------------------------------------------------------*/
	
#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STECNT(action,cont,log,disp)
CHARACTER   action;	/* IN: GET or PUT */
fint2c *cont;		/* IN: pointer to continuation flag */
fint2c *log;		/* IN: pointer to log flag */
fint2c *disp;		/* IN: pointer to display flag */
#else     /* ==== Generated Code === */
#define STECNT	stecnt_
STECNT(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	SCECNT(CHAR_LOC(1,4,0),PARAM(2,4,1,fint2c *),PARAM(3,4,1,fint2c *),PARAM(4,4,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STESIG(sys,text,stat)
CHARACTER   sys;	/* IN: text */
CHARACTER   text;	/* IN: text */
fint2c *stat;		/* IN: error number */
#else     /* ==== Generated Code === */
#define STESIG	stesig_
STESIG(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	SCESIG(STRIPPED_STRING(1,3,0),STRIPPED_STRING(2,3,1),*PARAM(3,3,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STETER(errno,text)
fint2c *errno;		/* IN: error no. */
CHARACTER   text;	/* IN: messages to display */
#else     /* ==== Generated Code === */
#define STETER	steter_
STETER(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

	SCETER(*PARAM(1,2,0,fint2c *),STRIPPED_STRING(2,2,0));
  ftoc_free(FORmark);    /* <forif> */
}
