#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stdd.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:31 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STDD.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STDD.FC
.COMMENTS
Module contains layer between the descriptor related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [1.80] 871210:  add data type option
.VERSION  [1.90] 880125:  take care of base address in 'vmr'
.VERSION  [2.00] 880127:  add STFPUT, STFGET
.VERSION  [2.10] 880208:  make sure, that CHARACTER is used only for a single
                          variable
.VERSION  [2.50] 880401:  new version - split up numeric + character stuff !
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [3.00] 901213:  Master file. CG.
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STDWRC(no,descr,noelm,values,felem,maxvals,dunit,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name (max. 15 char.) */
fint2c	*noelm;		/* IN : CHAR*noelm  */
CHARACTER   values;	/* IN : buffer with descriptor data */
fint2c	*felem;		/* IN : position of 1st descrip. value to be accessed */
fint2c	*maxvals;	/* IN : no. of data values to write */
fint2c	*dunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDWRC	stdwrc_
STDWRC(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(8,8,2,fint2c *) = SCDWRC(*PARAM(1,8,0,fint2c *),STRIPPED_STRING(2,8,0),*PARAM(3,8,1,fint2c *),
		     CHAR_LOC(4,8,1),*PARAM(5,8,2,fint2c *),*PARAM(6,8,2,fint2c *),PARAM(7,8,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDWRD(no,descr,values,felem,maxvals,dunit,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name (max. 15 char.) */
double	*values;	/* IN : buffer with descriptor data */
fint2c	*felem;		/* IN : position of 1st descrip. value to be accessed */
fint2c	*maxvals;	/* IN : no. of data values to write */
fint2c	*dunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDWRD	stdwrd_
STDWRD(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(7,7,1,fint2c *) = SCDWRD(*PARAM(1,7,0,fint2c *),STRIPPED_STRING(2,7,0),PARAM(3,7,1,double *),*PARAM(4,7,1,fint2c *),*PARAM(5,7,1,fint2c *),PARAM(6,7,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDWRH(no,descr,values,felem,maxvals,status)
fint2c    *no;            /* IN : no. of data frame */
CHARACTER   descr;      /* IN : descriptor name (max. 15 char.) */
CHARACTER   values;     /* IN : buffer with descriptor data */
fint2c    *felem;         /* IN : position of 1st descrip. value to be accessed */
fint2c    *maxvals;       /* IN : no. of data values to write */
fint2c    *status;
#else     /* ==== Generated Code === */
#define STDWRH	stdwrh_
STDWRH(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(6,6,2,fint2c *) = SCDWRH(*PARAM(1,6,0,fint2c *),STRIPPED_STRING(2,6,0),
                     CHAR_LOC(3,6,1),*PARAM(4,6,2,fint2c *),*PARAM(5,6,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDWRI(no,descr,values,felem,maxvals,dunit,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name (max. 15 char.) */
fint2c	*values;	/* IN : buffer with descriptor data */
fint2c	*felem;		/* IN : position of 1st descrip. value to be accessed */
fint2c	*maxvals;	/* IN : no. of data values to write */
fint2c	*dunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDWRI	stdwri_
STDWRI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(7,7,1,fint2c *) = SCDWRI(*PARAM(1,7,0,fint2c *),STRIPPED_STRING(2,7,0),PARAM(3,7,1,fint2c *),*PARAM(4,7,1,fint2c *),*PARAM(5,7,1,fint2c *),PARAM(6,7,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDWRR(no,descr,values,felem,maxvals,dunit,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name (max. 15 char.) */
float	*values;	/* IN : buffer with descriptor data */
fint2c	*felem;		/* IN : position of 1st descrip. value to be accessed */
fint2c	*maxvals;	/* IN : no. of data values to write */
fint2c	*dunit;		/* IN : unit-pointer */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDWRR	stdwrr_
STDWRR(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(7,7,1,fint2c *) = SCDWRR(*PARAM(1,7,0,fint2c *),STRIPPED_STRING(2,7,0),PARAM(3,7,1,float *),*PARAM(4,7,1,fint2c *),*PARAM(5,7,1,fint2c *),PARAM(6,7,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}
