#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stda.fc	16.1.1.1 (ESO-DMD) 06/19/01 15:16:30 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STDA.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STDA.FC
.COMMENTS
Module contains layer between the descriptor related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [1.80] 871210:  add data type option
.VERSION  [1.90] 880125:  take care of base address in 'vmr'
.VERSION  [2.10] 880208:  make sure, that CHARACTER is used only for a single
                          variable
.VERSION  [2.50] 880401:  new version - split up numeric + character stuff !
.VERSION  [2.60] 880411:  modified new version - the last one
.VERSION  [3.00] 901213:  Master file. CG.

000605
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STDCOP(from,to,mask,descr,status)
fint2c	*from;		/* IN: no. of source frame  */
fint2c	*to;		/* IN: no. of destination frame  */
fint2c	*mask;		/* IN: copy_mask  */
CHARACTER   descr;	/* IN: name of descr. to copy (if mask = 4) */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDCOP	stdcop_
STDCOP(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(5,5,1,fint2c *) = SCDCOP(*PARAM(1,5,0,fint2c *),*PARAM(2,5,0,fint2c *),*PARAM(3,5,0,fint2c *),STRIPPED_STRING(4,5,0));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDFND(no,descr,type,noelem,bytelem,status)
fint2c	*no;		/* IN: no. of data frame  */
CHARACTER   descr;	/* IN:  descriptor name  */
CHARACTER   type;	/* OUT: type of descr - I, R, C, D or ' '   */
fint2c	*noelem;	/* OUT: no. of elements  */
fint2c	*bytelem;	/* OUT: no. of bytes per element  */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDFND	stdfnd_
STDFND(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(6,6,2,fint2c *) = SCDFND(*PARAM(1,6,0,fint2c *),STRIPPED_STRING(2,6,0),CHAR_LOC(3,6,1),PARAM(4,6,2,fint2c *),PARAM(5,6,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDINF(no,npos,field,buf,numbuf,status)
fint2c	*no;		/* IN: no. of data frame  */
fint2c	*npos;		/* IN: position of descriptor, beginning with 1 */
fint2c	*field;		/* IN: specify info,1 = NAME, 2 = TYPE, 3 = SIZE */
CHARACTER   buf;	/* IN : buffer for character descriptor info */
fint2c	*numbuf;	/* IN : return buffer for numerical data  */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDINF	stdinf_
STDINF(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int  nn;

char  tbuf[84];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */



nn = *PARAM(3,6,0,fint2c *);
if (nn != 3)
   {
   CGN_FILL(tbuf,' ',80);
   *PARAM(6,6,1,fint2c *) = SCDINF(*PARAM(1,6,0,fint2c *),*PARAM(2,6,0,fint2c *),*PARAM(3,6,0,fint2c *),tbuf,79,PARAM(5,6,1,fint2c *));
   for (nn=0; nn<48; nn++)
      {
      if (tbuf[nn] == '\0') 
         {
         tbuf[nn] = ' ';
         goto copy_it;
         }
      if (tbuf[nn] == ' ') goto copy_it;
      }
   nn = 47;

copy_it:
   (void) strncpy(CHAR_LOC(4,6,0),tbuf,nn+1);	/* have a blank in the end */
   }

else
   *PARAM(6,6,1,fint2c *) = SCDINF(*PARAM(1,6,0,fint2c *),*PARAM(2,6,0,fint2c *),3,tbuf,48,PARAM(5,6,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */

}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDX(no,flag,descr,type,bytelm,noelm,hnc,status)
fint2c  *no;            /* IN : no. of data frame */
fint2c  *flag;          /* IN : action flag */
CHARACTER   descr;      /* OUT : descriptor name */
CHARACTER   type;       /* OUT : descriptor type */
fint2c  *bytelm;        /* OUT : no. of bytes per element */
fint2c  *noelm;         /* OUT : no. of elements */
fint2c  *hnc;           /* OUT : no. of help text chars */
fint2c  *status;
#else     /* ==== Generated Code === */
#define STDRDX	stdrdx_
STDRDX(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int  nn;

char  tbuf[60];  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


CGN_FILL(tbuf,' ',60);

*PARAM(8,8,2,fint2c *) = SCDRDX(*PARAM(1,8,0,fint2c *),*PARAM(2,8,0,fint2c *),tbuf,CHAR_LOC(4,8,1),PARAM(5,8,2,fint2c *),PARAM(6,8,2,fint2c *),PARAM(7,8,2,fint2c *));

for (nn=0; nn<48; nn++)
   {
   if (tbuf[nn] == '\0') 
      {
      tbuf[nn] = ' ';
      goto copy_it;
      }
   if (tbuf[nn] == ' ') goto copy_it;
   }

copy_it:
(void) strncpy(CHAR_LOC(3,8,0),tbuf,nn+1);	/* have a blank in the end */
  ftoc_free(FORmark);    /* <forif> */
}



