#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)std.fc	16.1.1.1 (ESO-DMD) 06/19/01 15:16:30 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Correspondence concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STD.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STD.FC
.COMMENTS
Module contains layer between the descriptor related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 871207:  created from SXFTOC.C
.VERSION  [1.90] 880125:  take care of base address in 'vmr'
.VERSION  [2.10] 880208:  make sure, that CHARACTER is used only for a single
                          variable
.VERSION  [2.50] 880401:  new version - split up numeric + character stuff !
.VERSION  [3.00] 901213:  Master file. CG.
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDC(no,descr,noelm,felem,maxvals,actvals,values,dunit,dnull,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name */
fint2c	*noelm;		/* IN : no. of "elements" in type, i.e. CHAR*noelm */
fint2c	*felem;		/* IN : position of 1st element to be accessed */
fint2c	*maxvals;	/* IN : max. no. of values to be returned */
fint2c	*actvals;	/* OUT: actual no. of values returned */
CHARACTER   values;	/* OUT: array for descriptor data */
fint2c	*dunit;		/* OUT: address of unit pointer    */
fint2c	*dnull;		/* OUT: no. of null values, will be applied, if not -1*/
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDRDC	stdrdc_
STDRDC(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(10,10,2,fint2c *) = SCDRDC(*PARAM(1,10,0,fint2c *),STRIPPED_STRING(2,10,0),*PARAM(3,10,1,fint2c *),*PARAM(4,10,1,fint2c *),
		     *PARAM(5,10,1,fint2c *),PARAM(6,10,1,fint2c *),CHAR_LOC(7,10,1),PARAM(8,10,2,fint2c *),PARAM(9,10,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDD(no,descr,felem,maxvals,actvals,values,dunit,dnull,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name */
fint2c	*felem;		/* IN : position of 1st element to be accessed */
fint2c	*maxvals;	/* IN : max. no. of values to be returned */
fint2c	*actvals;	/* OUT: actual no. of values returned */
double	*values;	/* OUT: array of type 'type' buffer for descrip. data */
fint2c	*dunit;		/* OUT: address of unit pointer    */
fint2c	*dnull;		/* OUT: no. of null values, will be applied, if not -1*/
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDRDD	stdrdd_
STDRDD(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(9,9,1,fint2c *) = SCDRDD(*PARAM(1,9,0,fint2c *),STRIPPED_STRING(2,9,0),*PARAM(3,9,1,fint2c *),
		     *PARAM(4,9,1,fint2c *),PARAM(5,9,1,fint2c *),PARAM(6,9,1,double *),PARAM(7,9,1,fint2c *),PARAM(8,9,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDH(no,descr,felem,maxvals,actvals,values,total,status)
fint2c    *no;            /* IN : no. of data frame */
CHARACTER   descr;      /* IN : descriptor name */
fint2c    *felem;         /* IN : position of 1st element to be accessed */
fint2c    *maxvals;       /* IN : max. no. of values to be returned */
fint2c    *actvals;       /* OUT: actual no. of values returned */
CHARACTER   values;     /* OUT: array for descriptor data */
fint2c    *total;         /* OUT: total size of help text*/
fint2c    *status;
#else     /* ==== Generated Code === */
#define STDRDH	stdrdh_
STDRDH(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(8,8,2,fint2c *) = SCDRDH(*PARAM(1,8,0,fint2c *),STRIPPED_STRING(2,8,0),*PARAM(3,8,1,fint2c *),
                     *PARAM(4,8,1,fint2c *),PARAM(5,8,1,fint2c *),CHAR_LOC(6,8,1),PARAM(7,8,2,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDI(no,descr,felem,maxvals,actvals,values,dunit,dnull,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name */
fint2c 	*felem;		/* IN : position of 1st element to be accessed */
fint2c	*maxvals;	/* IN : max. no. of values to be returned */
fint2c	*actvals;	/* OUT: actual no. of values returned */
fint2c	*values;	/* OUT: array of type 'type' buffer for descrip. data */
fint2c	*dunit;		/* OUT: address of unit pointer    */
fint2c	*dnull;		/* OUT: no. of null values, will be applied, if not -1*/
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDRDI	stdrdi_
STDRDI(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(9,9,1,fint2c *) = SCDRDI(*PARAM(1,9,0,fint2c *),STRIPPED_STRING(2,9,0),*PARAM(3,9,1,fint2c *),
		     *PARAM(4,9,1,fint2c *),PARAM(5,9,1,fint2c *),PARAM(6,9,1,fint2c *),PARAM(7,9,1,fint2c *),PARAM(8,9,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDR(no,descr,felem,maxvals,actvals,values,dunit,dnull,status)
fint2c	*no;		/* IN : no. of data frame */
CHARACTER   descr;	/* IN : descriptor name */
fint2c	*felem;		/* IN : position of 1st element to be accessed */
fint2c	*maxvals;	/* IN : max. no. of values to be returned */
fint2c	*actvals;	/* OUT: actual no. of values returned */
float	*values;	/* OUT: array of type 'type' buffer for descrip. data */
fint2c	*dunit;		/* OUT: address of unit pointer    */
fint2c	*dnull;		/* OUT: no. of null values, will be applied, if not -1*/
fint2c	*status;
#else     /* ==== Generated Code === */
#define STDRDR	stdrdr_
STDRDR(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */
	
    *PARAM(9,9,1,fint2c *) = SCDRDR(*PARAM(1,9,0,fint2c *),STRIPPED_STRING(2,9,0),*PARAM(3,9,1,fint2c *),
		     *PARAM(4,9,1,fint2c *),PARAM(5,9,1,fint2c *),PARAM(6,9,1,float *),PARAM(7,9,1,fint2c *),PARAM(8,9,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STDRDZ(no,dirsize,direlem,status)
fint2c  *no;            /* IN : no. of data frame */
fint2c  *dirsize;	/* OUT : no. of chars used by descr-directory */
fint2c  *direlem;	/* OUT : no. of descr. (incl directory) */
fint2c  *status;
#else     /* ==== Generated Code === */
#define STDRDZ	stdrdz_
STDRDZ(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  va_start(Cargs);       /* <forif> */

*PARAM(4,4,0,fint2c *) = SCDRDZ(*PARAM(1,4,0,fint2c *),PARAM(2,4,0,fint2c *),PARAM(3,4,0,fint2c *));
}

