#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)stcb.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:30 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  STC.FC +++++++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module STC.FC
.COMMENTS
Module contains layer between the catalog related FORTRAN STxxxx interfaces
and the SC_interfaces written in (hopefully independent) C
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       standard interfaces.
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 880919:  created
.VERSION  [1.20] 881010:  add SZCSHO
.VERSION  [1.30] 890119:  updated
.VERSION  [1.40] 900219:  update parameters of SZCSHO
.VERSION  [3.00] 901213:  Master file. CG.
-----------------------------------------------------------------------------*/


#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE STCLIS(catfile,intval,status)
CHARACTER   catfile;	/* IN: catalog file  */
fint2c *intval;		/* IN: listing interval [low,hi]  */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STCLIS	stclis_
STCLIS(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(3,3,1,fint2c *) = SCCLIS(STRIPPED_STRING(1,3,0),PARAM(2,3,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE STCSHO(catfile,totent,lastent,status)
CHARACTER   catfile;	/* IN: catalog file  */
fint2c	*totent;	/* OUT: no. of entries */
fint2c	*lastent;	/* OUT: last entry no. */
fint2c	*status;
#else     /* ==== Generated Code === */
#define STCSHO	stcsho_
STCSHO(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

    *PARAM(4,4,1,fint2c *) = SCCSHO(STRIPPED_STRING(1,4,0),PARAM(2,4,1,fint2c *),PARAM(3,4,1,fint2c *));
  ftoc_free(FORmark);    /* <forif> */
}
