#define vmr	vmr_		/* parameter for Name Translation is l_ */
#define ROUTINE int
/* @(#)genftocb.fc	16.1.1.1 (ES0-DMD) 06/19/01 15:16:29 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++  GENFTOCB.FC  +++++++++++++++++++++++++++++++++++
.LANGUAGE C
.IDENTIFICATION Module GENFTOCB.FC
.COMMENTS
Contains GENEQF, GENLEN, ISSUBF, DSCUPT
.AUTHOR         K. Banse  	ESO - Garching
.KEYWORDS       tools
.ENVIRONMENT    FORTRAN and C standards
.VERSION  [1.00] 920507:  Created + extracted from genftoc.fc + utilz.fc
-----------------------------------------------------------------------------*/

#include <ftoc.h>
#include <midas_def.h>


#if 0     /* ==== Original Code ==== */
SUBROUTINE GENEQF(afile,bfile,retval)
CHARACTER   afile;	/* IN: 1. file name (terminated by \0) */
CHARACTER   bfile;	/* IN: 2. file name (terminated by \0) */
fint2c	*retval;	/* OUT: =1 if Equal, =0 if Differ      */
#else     /* ==== Generated Code === */
#define GENEQF	geneqf_
GENEQF(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */

int retstat;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


retstat = CGN_EQUAL(STRIPPED_STRING(1,3,0),STRIPPED_STRING(2,3,1));
*PARAM(3,3,2,fint2c *) = 1 - retstat;		/* retstat = 0 if equal and 1 if not ...  */
  ftoc_free(FORmark);    /* <forif> */

}

#if 0     /* ==== Original Code ==== */
SUBROUTINE GENLEN(strung,retval)
CHARACTER   strung;	/* IN: 1. file name (terminated by \0) */
fint2c    *retval;
#else     /* ==== Generated Code === */
#define GENLEN	genlen_
GENLEN(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

*PARAM(2,2,1,fint2c *) = strlen(STRIPPED_STRING(1,2,0));
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE ISSUBF(infile,indx)
CHARACTER   infile;     /* IN: input file name                  */
fint2c *indx;		/* OUT: index of substring specs, else = 0 */
#else     /* ==== Generated Code === */
#define ISSUBF	issubf_
ISSUBF(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */


int nx;  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */


nx = issub(STRIPPED_STRING(1,2,0));
if (nx > 0)
   *PARAM(2,2,1,fint2c *) = nx + 1;		/* in C we start from 0 ...  */
else
   *PARAM(2,2,1,fint2c *) = 0;
  ftoc_free(FORmark);    /* <forif> */
}

#if 0     /* ==== Original Code ==== */
SUBROUTINE DSCUPT(inno,outno,history,status)

fint2c    *inno;		/* IN: source file no. */
fint2c    *outno;		/* IN: dest. file no. */
CHARACTER   history;    /* IN: eventual history string */
fint2c *status;
#else     /* ==== Generated Code === */
#define DSCUPT	dscupt_
DSCUPT(va_alist) va_dcl 
{ va_list Cargs;
#endif    /* ======================= */
  int FORmark;           /* <forif> */
  va_start(Cargs);       /* <forif> */
  FORmark = ftoc_mark(); /* <forif> */

*PARAM(4,4,1,fint2c *) = CGN_DSCUPD(*PARAM(1,4,0,fint2c *),*PARAM(2,4,0,fint2c *),C_STRING(3,4,0));
  ftoc_free(FORmark);    /* <forif> */
}

